/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.accounting;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.TextFilterator;
import ca.odell.glazedlists.matchers.TextMatcherEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.DefaultMutableTreeNode;
import officemate.components.table.PersistentObjectTable;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.EditablePropertyColumnFormat;
import officemate.components.tableformat.renderers.AutoCompleteComboCellEditor;
import officemate.screens.setup.configuration.accounting.SimpleSelectionTreePanel;
import ordermate.OrderMate;
import ordermate.database.integration.accounting.settings.AccountingClassType;
import ordermate.database.integration.accounting.settings.GLAccount;
import ordermate.reports.table.ColumnFormat;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import org.jdesktop.swingx.JXHeader;

public class GLAccountSetupPanel
extends JPanel {
    public final Signal tableEdited = Signals.createSignal(Object.class, (String)"edited object");
    private JSplitPane splitter;
    private PersistentObjectTable<GLAccount> table;
    private SimpleSelectionTreePanel accClassTypeTreePanel;
    private FilterList<GLAccount> filteredGLAccountList;
    private TextMatcherEditor<GLAccount> textMatcher;

    public GLAccountSetupPanel(EventList<GLAccount> glAccountList) {
        this.setLayout(new BorderLayout());
        this.setName("GL Account Setup");
        JXHeader instructionsHeading = new JXHeader("", "Use this screen to setup the GL Accounts. GL Accounts can be set to be not exported or to be grouped i.e. all GL Account Links with this GL Account will be grouped into the one entry.");
        Box box = new Box(1);
        box.add((Component)instructionsHeading);
        box.add(new JSeparator());
        this.add((Component)box, "North");
        this.splitter = new JSplitPane();
        this.accClassTypeTreePanel = new SimpleSelectionTreePanel(this.buildTreeNodeStructure());
        this.accClassTypeTreePanel.objectSelected.connect((Object)this, "setAccountingClassTypeFilter");
        this.splitter.setLeftComponent(this.accClassTypeTreePanel);
        this.textMatcher = new TextMatcherEditor((TextFilterator)new AccountingClassTypeFilterator());
        this.filteredGLAccountList = new FilterList(glAccountList, this.textMatcher);
        this.initTable();
        this.add((Component)this.splitter, "Center");
    }

    private DefaultMutableTreeNode buildTreeNodeStructure() {
        DefaultMutableTreeNode allNode = new DefaultMutableTreeNode("All");
        for (AccountingClassType accClassType : AccountingClassType.values()) {
            allNode.add(new DefaultMutableTreeNode(accClassType.getDescription()));
        }
        return allNode;
    }

    public void initTable() {
        this.table = new PersistentObjectTable<GLAccount>((EventList<GLAccount>)this.filteredGLAccountList, new ColumnTableFormat(new ColumnFormat[]{((EditablePropertyColumnFormat)new EditablePropertyColumnFormat("Type", GLAccount.Properties.TYPE).setCustomRenderer(new AccountingClassTypeCellRenderer())).setCustomEditor((TableCellEditor)((Object)new TypeAutoCompleteComboCellEditor((EventList)this.getAllAccountingClassTypes()))), new EditablePropertyColumnFormat("Name", GLAccount.Properties.NAME), new EditablePropertyColumnFormat("GL Code", GLAccount.Properties.GL_CODE), new EditablePropertyColumnFormat("Exported", GLAccount.Properties.EXPORTED), new EditablePropertyColumnFormat("Grouped", GLAccount.Properties.GROUPED)}));
        this.splitter.setRightComponent(this.table);
        this.splitter.setDividerLocation(160);
        this.table.objectEdited().connect((Object)this, "glAccountEdited");
    }

    protected void setAccountingClassTypeFilter(Object selected) {
        if (this.table.getTable().isEditing()) {
            this.table.getTable().getCellEditor().stopCellEditing();
        }
        try {
            if (!"All".equals(selected)) {
                this.textMatcher.setFilterText(new String[]{(String)selected});
            } else {
                this.textMatcher.setFilterText(new String[0]);
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error settings the GL Account filter.", (Throwable)ex);
        }
    }

    protected void glAccountEdited(Object edited) {
        this.tableEdited.emit(edited);
    }

    private BasicEventList<String> getAllAccountingClassTypes() {
        BasicEventList allAccountingClassType = new BasicEventList();
        for (AccountingClassType type : AccountingClassType.values()) {
            allAccountingClassType.add((Object)type.getDescription());
        }
        return allAccountingClassType;
    }

    public GLAccount getSelected() {
        return this.table.getSelectedObject();
    }

    protected PersistentObjectTable<GLAccount> getTable() {
        return this.table;
    }

    private static final class TypeAutoCompleteComboCellEditor
    extends AutoCompleteComboCellEditor {
        public TypeAutoCompleteComboCellEditor(EventList data) {
            super(data);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return super.getTableCellEditorComponent(table, value != null ? ((AccountingClassType)value).getDescription() : value, isSelected, row, column);
        }

        @Override
        public Object getCellEditorValue() {
            Object obj = super.getCellEditorValue();
            if (obj instanceof String) {
                try {
                    return AccountingClassType.getEnumForDescription((String)((String)super.getCellEditorValue()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return obj;
        }
    }

    public class AccountingClassTypeFilterator
    implements TextFilterator {
        public void getFilterStrings(List baseList, Object element) {
            baseList.add(((GLAccount)element).getType().getDescription());
        }
    }

    public class AccountingClassTypeCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                this.setText("");
            } else {
                this.setText(((AccountingClassType)value).getDescription());
            }
            return this;
        }
    }
}

