/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.actions;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.HtmlUtils;
import au.com.ordermate.util.image.IconLoader;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import javax.swing.Action;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.dialogs.OfficeMateGuiHandler;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.screens.setup.configuration.actions.ConfigActionEditor;
import ordermate.action.ActionManager;
import ordermate.action.ConfigActionTask;
import ordermate.database.EventContext;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.misc.action.ActionType;
import ordermate.database.misc.action.ConfigAccountAction;
import ordermate.database.misc.action.ConfigAction;
import ordermate.database.misc.action.ConfigButtonAction;
import ordermate.database.misc.action.ConfigTimerAction;
import ordermate.database.sales.Account;
import ordermate.database.sales.BarTabAccount;
import ordermate.database.sales.ItemGroup;
import ordermate.database.users.User;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class ConfigActionSetupState
extends AbstractEditableTableState<ConfigAction> {
    private Action fireAction = new BasicAction("Fire Action", IconLoader.get((String)"/ordermate/images/uparrow.png")){

        public void actionPerformed(ActionEvent e) {
            Account account = (Account)PersistenceManager.getObject(BarTabAccount.class, (String)Query.select(BarTabAccount.class).limit(1).toString());
            if (account == null) {
                account = (Account)PersistenceManager.getObject(Account.class, (String)Query.select(Account.class).limit(1).toString());
            }
            EventContext eventContext = new EventContext((Terminal)PersistenceManager.getObject(Terminal.class, (String)Query.select(Terminal.class).limit(1).toString()), User.getSystemUser());
            TriggerActivationContext context = new TriggerActivationContext(eventContext, (ItemGroup)account);
            if (ActionManager.getInstance() == null) {
                ActionManager.init((boolean)false, (GuiHandler)new OfficeMateGuiHandler());
            }
            ActionManager.getInstance().gotAction(new ConfigActionTask((ConfigAction)ConfigActionSetupState.this.getCentralArea().getSelectedObject(), context, true));
        }
    };

    public ConfigActionSetupState() {
        this.addSelectionDependentAction(this.fireAction);
    }

    @Override
    protected ObjectEditor<ConfigAction> createObjectEditor() {
        return new ConfigActionEditor();
    }

    @Override
    public String getTypeName() {
        return "Action";
    }

    @Override
    protected TableStateCentralArea<ConfigAction> createCentralArea() {
        ColumnTableFormat cols = new ColumnTableFormat();
        cols.addColumn((ColumnFormat)new PropertyColumnFormat("Label", ConfigAction.Properties.LABEL));
        cols.addColumn((ColumnFormat)new PropertyColumnFormat("Sequence", ConfigAction.Properties.SEQUENCE));
        cols.addColumn((ColumnFormat)new PropertyColumnFormat("Url", (PropertiedObject.Property)ConfigAction.Properties.URL));
        PersistentObjectTable<ConfigAction> table = new PersistentObjectTable<ConfigAction>(this.getObjectList(), cols);
        return table;
    }

    @Override
    protected Class<ConfigAction> getDisplayingType() {
        return ConfigAction.class;
    }

    @Override
    public ConfigAction createNewObject() {
        String list = HtmlUtils.orderedList((boolean)true, (String[])new String[]{"Timer - fires every x seconds", "Button - inserts a Button into Waitermate", "Account - fires an action based on an account event"});
        String prompt = HtmlUtils.html((String)("There are several types of Actions:" + list));
        ActionType returned = (ActionType)Dialogs.showOptionDialog("Choose the type of Action:", prompt, Arrays.asList(ActionType.values()));
        ConfigAccountAction action = null;
        if (returned != null) {
            switch (returned) {
                case Account: {
                    action = new ConfigAccountAction("New Account Action");
                    break;
                }
                case Timer: {
                    action = new ConfigTimerAction("New Timer Action");
                    break;
                }
                case Button: {
                    action = new ConfigButtonAction("New Button Action");
                    break;
                }
            }
        }
        return action;
    }

    @Override
    public boolean canCreateOrDelete() {
        return true;
    }
}

