/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.advanced;

import au.com.ordermate.persistence.Executable;
import au.com.ordermate.persistence.PersistenceManager;
import ca.odell.glazedlists.GlazedLists;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JOptionPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import officemate.components.AbstractObjectEditor;
import ordermate.OrderMate;
import ordermate.database.finance.tax.TaxCode;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.enums.MessageServerType;
import ordermate.gui.FieldPanelBuilder;
import ordermate.integration.cloudback.nudge.NudgeHelper;
import ordermate.misc.logging.ErrorTrackingProvider;
import ordermate.services.database.ClearMasterIdsExecutable;
import org.jdesktop.beansbinding.AutoBinding;

public class AdvancedSystemPropertyEditor
extends AbstractObjectEditor
implements ActionListener,
ItemListener {
    private final int textCols = 26;
    private JButton clearMasterIdsBut;
    private JComboBox<MessageServerType> messageServerTypeJComboBox;
    private JCheckBox showACCIDcheckBox;
    private JCheckBox traningModecheckBox;
    private JCheckBox stockControlcheckBox;
    private JComboBox errorTrackingcheckBox;
    private JTextField supportMessage1TextField;
    private JTextField supportMessage2TextField;
    private JSpinner messageServerSpinner;
    private JTextField updatedmateScriptTextField;
    private JFormattedTextField workflowTextField;
    private JComboBox baseTaxCodecheckBox;
    private JTextField dbIntegrityCheckCronTextField;

    public AdvancedSystemPropertyEditor(String editable) {
        if (!editable.equals("ENABLED")) {
            this.messageServerTypeJComboBox.setEnabled(false);
            this.clearMasterIdsBut.setEnabled(false);
            this.showACCIDcheckBox.setEnabled(false);
            this.traningModecheckBox.setEnabled(false);
            this.stockControlcheckBox.setEnabled(false);
            this.errorTrackingcheckBox.setEnabled(false);
            this.supportMessage1TextField.setEnabled(false);
            this.supportMessage2TextField.setEnabled(false);
            this.messageServerSpinner.setEnabled(false);
            this.updatedmateScriptTextField.setEnabled(false);
            this.workflowTextField.setEnabled(false);
            this.baseTaxCodecheckBox.setEnabled(false);
            this.dbIntegrityCheckCronTextField.setEnabled(false);
        }
    }

    @Override
    public void init() {
        super.init();
        this.getBindings().setStrategy(AutoBinding.UpdateStrategy.READ_WRITE);
        FieldPanelBuilder leftBuilder = new FieldPanelBuilder();
        FieldPanelBuilder rightBuilder = new FieldPanelBuilder();
        this.messageServerTypeJComboBox = this.setupComboBox(SystemProperty.Properties.MESSAGE_SERVER_TYPE, GlazedLists.eventListOf((Object[])MessageServerType.values()));
        this.clearMasterIdsBut = new JButton("Clear IDs");
        this.showACCIDcheckBox = this.setupCheckBox(SystemProperty.Properties.SHOW_ACC_ID);
        this.traningModecheckBox = this.setupCheckBox(SystemProperty.Properties.TRAINING_MODE_ENABLED);
        this.stockControlcheckBox = this.setupCheckBox(SystemProperty.Properties.STOCK_CONTROL_ENABLED);
        this.errorTrackingcheckBox = this.setupComboBox(SystemProperty.Properties.ERROR_TRACKING_PROVIDER, GlazedLists.eventListOf((Object[])ErrorTrackingProvider.values()));
        this.supportMessage1TextField = this.setupTextField(SystemProperty.Properties.SUPPORT_MESSAGE1, 26);
        this.supportMessage2TextField = this.setupTextField(SystemProperty.Properties.SUPPORT_MESSAGE2, 26);
        this.messageServerSpinner = this.setupIntSpinner(SystemProperty.Properties.MESSAGE_SERVER_POLL_TIME, 10, 10, 2400, 60, 5);
        this.updatedmateScriptTextField = this.setupTextField(SystemProperty.Properties.UPDATEMATE_SCRIPT_DIR, 26);
        this.workflowTextField = this.setupLongField(SystemProperty.Properties.WORKFLOW_FREQUENCY, 26, 500L, 10000L);
        this.baseTaxCodecheckBox = this.setupComboBox(SystemProperty.Properties.BASE_TAX_CODE, GlazedLists.eventList((Collection)TaxCode.getInventoryTaxCodes()));
        this.dbIntegrityCheckCronTextField = this.setupTextField(SystemProperty.Properties.DB_CHECK_SCHEDULE, 26);
        leftBuilder.addRow("Show account ID", (Component)this.showACCIDcheckBox);
        leftBuilder.addRow("Training Mode", (Component)this.traningModecheckBox);
        leftBuilder.addRow("Message Server", this.messageServerTypeJComboBox);
        leftBuilder.addRow("Stock Control Enabled", (Component)this.stockControlcheckBox);
        leftBuilder.addRow("Clear Master IDs", (Component)this.clearMasterIdsBut);
        leftBuilder.addRow("Error Tracking Provider", (Component)this.errorTrackingcheckBox);
        rightBuilder.addRow("Support Message 1", (Component)this.supportMessage1TextField);
        rightBuilder.addRow("Support Message 2", (Component)this.supportMessage2TextField);
        rightBuilder.addRow("Msg Server Update time sec", (Component)this.messageServerSpinner);
        rightBuilder.addRow("UpdateMate Script Directory", (Component)this.updatedmateScriptTextField);
        rightBuilder.addRow("Workflow frequency", (Component)this.workflowTextField, "Custom polling rate for Workflows");
        rightBuilder.addRow("Base Tax Code", (Component)this.baseTaxCodecheckBox);
        rightBuilder.addRow("Database Integrity Check Cron Schedule", (Component)this.dbIntegrityCheckCronTextField);
        this.setLayout(new BorderLayout());
        this.add("West", leftBuilder.getPanel());
        this.add("East", rightBuilder.getPanel());
        this.clearMasterIdsBut.addActionListener(this);
        this.messageServerTypeJComboBox.addActionListener(this);
        this.messageServerTypeJComboBox.addItemListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        MessageServerType messageServerType;
        if (e.getSource() == this.clearMasterIdsBut) {
            this.clearMasterIds();
        } else if (e.getSource() == this.messageServerTypeJComboBox && MessageServerType.NUDGE.equals((Object)(messageServerType = (MessageServerType)this.messageServerTypeJComboBox.getSelectedItem()))) {
            this.enableNudge(true);
        }
    }

    private void clearMasterIds() {
        ClearMasterIdsExecutable exec = new ClearMasterIdsExecutable();
        Thread executingThread = new Thread(new Runnable((Executable)exec){
            final /* synthetic */ Executable val$exec;
            {
                this.val$exec = executable;
            }

            @Override
            public void run() {
                PersistenceManager.getServerConnection().runSync(this.val$exec);
            }
        });
        executingThread.setDaemon(true);
        executingThread.start();
        JOptionPane.showMessageDialog(this, "Clearing Master Ids - This may take a short while.", "Generating Report", 1);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        MessageServerType deSelectedType;
        if (e.getStateChange() == 2 && MessageServerType.NUDGE.equals((Object)(deSelectedType = (MessageServerType)e.getItem()))) {
            this.enableNudge(false);
        }
    }

    private void enableNudge(boolean enable) {
        OrderMate.LOG.info("enable Nudge : " + enable);
        new NudgeHelper().enableNudge(enable);
    }
}

