/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.advanced;

import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.util.image.IconLoader;
import ca.odell.glazedlists.EventList;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.table.TableCellEditor;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.EditablePropertyColumnFormat;
import officemate.components.tableformat.renderers.CronExpCellEditor;
import ordermate.OrderMate;
import ordermate.database.schedule.Schedule;
import ordermate.scheduler.RunNowAction;
import ordermate.scheduler.quartz.CronExpression;
import ordermate.serverconnection.PropertiesServerClient;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.autocomplete.ComboBoxCellEditor;

public class SchedulerSetupState
extends AbstractEditableTableState {
    private final JComboBox allTasks;
    private RunNowAction runAction;

    public SchedulerSetupState() {
        super("Schedule", null, "Add, modify and remove task into the scheduler");
        this.setSmallIcon(IconLoader.get((String)"/officemate/images/clock.png"));
        String[] tasks = new String[]{"None"};
        try {
            tasks = (String[])PropertiesServerClient.getProperty((String)"Tasks");
        }
        catch (RemoteException ex) {
            ex.printStackTrace();
        }
        this.allTasks = new JComboBox<String>(tasks);
    }

    @Override
    protected void init() {
        if (this.initCalled) {
            return;
        }
        super.init();
        this.addAction((Action)this.getRunAction());
        this.addAction(new AbstractAction("Evaluate Cron"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Schedule schedule = (Schedule)SchedulerSetupState.this.getCentralArea().getSelectedObject();
                String toEval = "0 0 0 * * ?";
                if (schedule != null && !schedule.getRecurrence().contains("@")) {
                    toEval = schedule.getRecurrence();
                }
                toEval = JOptionPane.showInputDialog("Input Cron Expression", (Object)toEval);
                String toShow = null;
                try {
                    CronExpression exp = new CronExpression(toEval);
                    toShow = exp.getNextValidTimeAfter(new Date()).toString();
                    Dialogs.showInfoDialog("Next Schedule Time", toShow);
                }
                catch (Exception ex) {
                    Dialogs.showInfoDialog("Invalid Cron", "Please see logs");
                    OrderMate.LOG.warn("Bad Cron", (Throwable)ex);
                }
            }
        });
    }

    protected ObjectEditor createObjectEditor() {
        return null;
    }

    @Override
    public String getTypeName() {
        return "Scheduler";
    }

    @Override
    public void doNewAction() {
        Schedule toAdd = new Schedule();
        if (this.allTasks.getModel().getSize() > 0) {
            toAdd.setTask((String)this.allTasks.getModel().getElementAt(0));
        }
        toAdd.setRecurrence("@reboot");
        EventList objectList = this.getObjectList();
        objectList.getReadWriteLock().writeLock().lock();
        try {
            objectList.add((Object)toAdd);
        }
        finally {
            objectList.getReadWriteLock().writeLock().unlock();
        }
        JXTable table = this.getCentralArea().getTable();
        int lastAddedRow = table.getFilters().convertRowIndexToView(table.getRowCount() - 1);
        table.clearSelection();
        table.addRowSelectionInterval(lastAddedRow, lastAddedRow);
        table.scrollRowToVisible(lastAddedRow);
    }

    @Override
    protected TableStateCentralArea<Schedule> createCentralArea() {
        this.setFilterActive(true);
        PersistentObjectTable<Schedule> centralArea = new PersistentObjectTable<Schedule>(this.getObjectList(), new ColumnTableFormat(new EditablePropertyColumnFormat[]{new EditablePropertyColumnFormat(Schedule.Properties.LABEL), new EditablePropertyColumnFormat(Schedule.Properties.RECURRENCE).setCustomEditor(new CronExpCellEditor()), new EditablePropertyColumnFormat(Schedule.Properties.TASK).setCustomEditor((TableCellEditor)new ComboBoxCellEditor(this.allTasks))}));
        centralArea.noObjectSelected().connect((Object)this, "gotNoSelection");
        centralArea.objectSelected().connect((Object)this, "gotSelection");
        return centralArea;
    }

    @Override
    public void gotObjectDoubleClicked(Object toEdit) {
    }

    @Override
    protected Class getDisplayingType() {
        return Schedule.class;
    }

    private RunNowAction getRunAction() {
        if (this.runAction == null) {
            this.runAction = new RunNowAction();
            this.runAction.setEnabled(false);
            this.runAction.task.connect((Object)this, "gotRun");
        }
        return this.runAction;
    }

    public void gotNoSelection() {
        this.runAction.setEnabled(false);
    }

    public void gotSelection() {
        this.runAction.setEnabled(true);
    }

    public void gotRun() {
        List tasks = this.getCentralArea().getAllSelectedObjects();
        this.runAction.setTasksToRun(tasks);
    }
}

