/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.advanced.appconfig;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import officemate.components.AbstractObjectEditor;
import ordermate.database.misc.application.ApplicationConfig;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.binding.validators.CompoundValidator;
import ordermate.gui.binding.validators.NumericalBindingValidator;
import ordermate.gui.binding.validators.NumericalValidator;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.Validator;

class AppConfigEditorPanel
extends AbstractObjectEditor<ApplicationConfig> {
    private JLabel appLabel;
    private JComboBox startingMemCombo;
    private JComboBox maximumMemCombo;

    AppConfigEditorPanel() {
    }

    @Override
    protected void init() {
        super.init();
        FieldPanelBuilder builder = new FieldPanelBuilder();
        this.appLabel = new JLabel("");
        builder.addRow("Application:", (Component)this.appLabel);
        Vector<Integer> minSuggestedVals = this.createDefaultMemoryAllocations();
        minSuggestedVals.setSize(minSuggestedVals.size() - 2);
        DefaultComboBoxModel<Integer> smModel = new DefaultComboBoxModel<Integer>(minSuggestedVals);
        this.startingMemCombo = new JComboBox<Integer>(smModel);
        this.startingMemCombo.setEditable(true);
        Binding startBinding = this.getBindings().createBinding(ApplicationConfig.Properties.STARTING_MEMORY, (Object)this.startingMemCombo, "selectedItem");
        builder.addRow("Starting Memory:", (Component)this.startingMemCombo);
        DefaultComboBoxModel<Integer> mmModel = new DefaultComboBoxModel<Integer>(this.createDefaultMemoryAllocations());
        this.maximumMemCombo = new JComboBox<Integer>(mmModel);
        this.maximumMemCombo.setEditable(true);
        Binding maxBinding = this.getBindings().createBinding(ApplicationConfig.Properties.MAXIMUM_MEMORY, (Object)this.maximumMemCombo, "selectedItem");
        builder.addRow("Maximum Memory:", (Component)this.maximumMemCombo);
        this.add(builder.getPanel());
        this.setupValidators(startBinding, maxBinding);
    }

    private void setupValidators(Binding startBinding, Binding maxBinding) {
        ArrayList<Object> startValidators = new ArrayList<Object>();
        startValidators.add(new NumericalValidator((Number)12.0, (Number)2048.0, Double.class));
        startValidators.add(new NumericalBindingValidator(NumericalBindingValidator.ComparisonStyle.Less, maxBinding));
        CompoundValidator validator = new CompoundValidator(CompoundValidator.CompoundStyle.AND, startValidators);
        startBinding.setValidator((Validator)validator);
        ArrayList<Object> maxValidators = new ArrayList<Object>();
        maxValidators.add(new NumericalValidator((Number)24.0, (Number)1000.0, Double.class));
        maxValidators.add(new NumericalBindingValidator(NumericalBindingValidator.ComparisonStyle.Greater, startBinding));
        maxBinding.setValidator((Validator)new CompoundValidator(CompoundValidator.CompoundStyle.AND, maxValidators));
    }

    @Override
    public void setObject(ApplicationConfig config) {
        this.appLabel.setText(config.getApplication().name());
        super.setObject(config);
    }

    private Vector<Integer> createDefaultMemoryAllocations() {
        int[] defaults = new int[]{32, 48, 55, 64, 76, 90, 105, 120, 135, 150, 180, 200, 250, 300, 350, 400, 512, 750, 1000, 2000, 3000, 4000};
        Vector<Integer> values = new Vector<Integer>(defaults.length);
        for (int nextInt : defaults) {
            values.add(nextInt);
        }
        return values;
    }
}

