/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.advanced.backup;

import au.com.ordermate.persistence.Executable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.Pair;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import officemate.adminkit.dialogs.Dialogs;
import ordermate.database.config.ConfigBackup;
import ordermate.services.misc.CallMethod;
import ordermate.services.misc.CallMethodOnClassExecutable;

class BackupRunnerUI {
    private static final String BACKUP_SERVICE = "servermate.services.backup.BackupService";
    private RunnerPanel UI;
    private final ConfigBackup config;
    private Thread mainThread;

    BackupRunnerUI(ConfigBackup config) {
        this.config = config;
        this.UI = new RunnerPanel();
    }

    public void start() {
        Dialogs.showOkCustomDialog("Backup", "Use this panel to perform backups on Servermate", this.UI);
    }

    private synchronized void run(final Executable exec) {
        if (this.mainThread != null) {
            return;
        }
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                try {
                    Object response = PersistenceManager.getServerConnection().runSync(exec);
                    BackupRunnerUI.this.gotResponse(response);
                }
                catch (Exception ex) {
                    BackupRunnerUI.this.mainThread = null;
                }
            }
        };
        this.mainThread = new Thread(runner);
        this.mainThread.start();
    }

    private void gotResponse(Object response) {
        if (response instanceof Pair) {
            Pair pair = (Pair)response;
            this.UI.setResponse((Boolean)pair.getKey(), (String)pair.getValue());
        } else if (response instanceof Boolean) {
            this.UI.setResponse((Boolean)response, this.config.getLastResult());
        }
        this.mainThread = null;
    }

    private void runOperation(String methodName) {
        this.UI.setResponse(null, "Running " + methodName + ", please wait...");
        CallMethod[] callMethods = new CallMethod[]{new CallMethod("getInstance", new Serializable[0]), new CallMethod("performOperation", new Serializable[]{this.config, methodName})};
        CallMethodOnClassExecutable exec = new CallMethodOnClassExecutable(BACKUP_SERVICE, callMethods);
        this.run((Executable)exec);
    }

    private void runBackup() {
        this.UI.setResponse(null, "Running Full Backup, please wait...");
        CallMethod[] callMethods = new CallMethod[]{new CallMethod("getInstance", new Serializable[0]), new CallMethod("runBackup", new Serializable[]{this.config})};
        CallMethodOnClassExecutable exec = new CallMethodOnClassExecutable(BACKUP_SERVICE, callMethods);
        this.run((Executable)exec);
    }

    private void checkRunning() {
        this.UI.setResponse(null, "Checking if running...");
        CallMethodOnClassExecutable exec = new CallMethodOnClassExecutable(BACKUP_SERVICE, new String[]{"getInstance", "isRunning"});
        Object val = PersistenceManager.getServerConnection().runSync((Executable)exec);
        if (val != null) {
            boolean value = (Boolean)val;
            this.UI.setResponse(!value, value ? "Currently Running" : "Not Running");
        }
    }

    class RunnerPanel
    extends JPanel
    implements ActionListener {
        private JButton checkRunning;
        private JButton performBackup;
        private JTextArea progressArea;
        private List<JButton> opButtons;
        private JPanel opHolder;

        public RunnerPanel() {
            this.setLayout(new BoxLayout(this, 1));
            this.progressArea = new JTextArea(10, 40);
            this.checkRunning = new JButton("Check if Running");
            this.checkRunning.addActionListener(this);
            this.performBackup = new JButton("Perform Full Backup");
            this.performBackup.addActionListener(this);
            this.add(new JScrollPane(this.progressArea));
            this.add(Box.createVerticalStrut(5));
            this.add(this.checkRunning);
            this.checkRunning.setAlignmentX(0.5f);
            this.add(Box.createVerticalStrut(5));
            this.add(this.performBackup);
            this.performBackup.setAlignmentX(0.5f);
            this.add(Box.createVerticalStrut(5));
            this.add(new JSeparator(0));
            this.add(Box.createVerticalStrut(5));
            this.opButtons = new ArrayList<JButton>();
            this.opHolder = new JPanel();
            this.opHolder.setLayout(new GridLayout(8, 1, 5, 5));
            this.opHolder.setBorder(new TitledBorder("Operations"));
            this.makeOpButton("Check Disk Space", "checkDiskSpace");
            this.makeOpButton("Pre-Verify Backup", "preVerify");
            this.makeOpButton("Copy", "doCopy");
            this.makeOpButton("Compress", "doCompress");
            this.makeOpButton("Post-Verify Backup", "postVerify");
            this.makeOpButton("Copy out to Local", "copyLocal");
            this.makeOpButton("Copy to LAN", "copyLan");
            this.makeOpButton("Remote Copy (FTP)", "copyRemote");
            this.makeOpButton("Clean Up", "cleanUp");
            this.add(this.opHolder);
        }

        private void enableButtons(boolean value) {
            this.checkRunning.setEnabled(value);
            this.performBackup.setEnabled(value);
            for (JButton nextOp : this.opButtons) {
                nextOp.setEnabled(value);
            }
        }

        public void setResponse(Boolean key, String value) {
            if (key != null) {
                this.progressArea.setText("Success=" + key + "\r\n" + value);
                this.enableButtons(true);
            } else {
                this.progressArea.setText(value);
                this.enableButtons(false);
            }
        }

        private void makeOpButton(String name, final String action) {
            JButton button = new JButton(name);
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BackupRunnerUI.this.runOperation(action);
                }
            });
            this.opButtons.add(button);
            this.opHolder.add(button);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == this.performBackup) {
                BackupRunnerUI.this.runBackup();
            } else if (source == this.checkRunning) {
                BackupRunnerUI.this.checkRunning();
            }
        }
    }
}

