/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.advanced.backup;

import java.awt.Component;
import java.text.DateFormat;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import officemate.components.AbstractObjectEditor;
import ordermate.database.config.ConfigBackup;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.binding.validators.NotEmptyValidator;
import org.jdesktop.beansbinding.Validator;

class ConfigBackupEditor
extends AbstractObjectEditor<ConfigBackup> {
    private JLabel lastSuccess;
    private JLabel lastError;
    private JTextArea resultArea;

    ConfigBackupEditor() {
        this.setupComponents();
    }

    private void setupComponents() {
        int cols = 50;
        FieldPanelBuilder builder = new FieldPanelBuilder();
        JComponent comp = this.setupCheckBox(ConfigBackup.Properties.ENABLED);
        builder.addRow("Enabled", (Component)comp);
        comp.setToolTipText("Check this box to enable backups.");
        comp = this.setupTextField(ConfigBackup.Properties.BACKUP_DIR, 50, (Validator)new NotEmptyValidator());
        builder.addRow("Directory To Backup", (Component)comp);
        comp.setToolTipText("The directory to be backed up, such as c:\\mysql\\ordermate_prod");
        comp = this.setupTextField(ConfigBackup.Properties.COPY_DIR, 50, (Validator)new NotEmptyValidator());
        builder.addRow("Temp Copy Directory", (Component)comp);
        comp.setToolTipText("The directory where the initial copy of the backup will be made");
        comp = this.setupTextField(ConfigBackup.Properties.BATCH_FILE, 50, (Validator)new NotEmptyValidator());
        builder.addRow("Temp Batch File", (Component)comp);
        comp.setToolTipText("The name of a temporary batch file that may be created during the backup process");
        comp = this.setupTextField(ConfigBackup.Properties.LOCAL_LOC, 50);
        builder.addRow("Local Location", (Component)comp);
        comp.setToolTipText("The local location, such as drive attached to this machine, to copy the backup to");
        comp = this.setupTextField(ConfigBackup.Properties.LAN_LOC, 50);
        builder.addRow("LAN Location", (Component)comp);
        comp.setToolTipText("A drive on the LAN, such as \\WMT1\\c$");
        comp = this.setupTextField(ConfigBackup.Properties.LAN_USER, 50);
        builder.addRow("LAN User", (Component)comp);
        comp.setToolTipText("The username for LAN access");
        comp = this.setupPasswordField(ConfigBackup.Properties.LAN_PASS, 50);
        builder.addRow("LAN Pass", (Component)comp);
        comp.setToolTipText("The password for LAN access");
        comp = this.setupTextField(ConfigBackup.Properties.REMOTE_LOC, 50);
        builder.addRow("Remote (FTP) Location", (Component)comp);
        comp.setToolTipText("The ftp or ftps location, like ftps://usw-s003.rsync.net");
        comp = this.setupTextField(ConfigBackup.Properties.REMOTE_USER, 50);
        builder.addRow("Remote User", (Component)comp);
        comp.setToolTipText("The username for remote access");
        comp = this.setupPasswordField(ConfigBackup.Properties.REMOTE_PASS, 50);
        builder.addRow("Remote Pass", (Component)comp);
        comp.setToolTipText("The password for remote access");
        this.lastSuccess = new JLabel();
        builder.addRow("Last Successful Backup", (Component)this.lastSuccess);
        this.lastSuccess.setToolTipText("The date and time of the last backup that ran to at least the backup phase");
        this.lastError = new JLabel();
        builder.addRow("Last Error", (Component)this.lastError);
        this.lastError.setToolTipText("The date and time of the last backup that ran with errors");
        this.resultArea = new JTextArea(4, 50);
        builder.addRow("Last Result", (Component)new JScrollPane(this.resultArea));
        this.resultArea.setEditable(false);
        this.add(builder.getPanel());
    }

    @Override
    public void setObject(ConfigBackup backup) {
        super.setObject(backup);
        this.resultArea.setText(backup.getLastResult());
        this.lastSuccess.setText(backup.getLastSuccess() != null ? DateFormat.getDateTimeInstance().format(backup.getLastSuccess()) : "None");
        this.lastError.setText(backup.getLastError() != null ? DateFormat.getDateTimeInstance().format(backup.getLastError()) : "None");
    }
}

