/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.advanced.cloudback;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.StringUtils;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.X509TrustManager;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import officemate.adminkit.dialogs.Dialogs;
import ordermate.OrderMate;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.gui.TerminalTypes;
import ordermate.database.hardware.Terminal;
import ordermate.database.integration.cloudback.CloudBackConfig;
import ordermate.database.integration.webservice.WebserviceIntegrationConfig;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.enums.ReservationIntegrationType;
import ordermate.database.misc.license.LicenseType;
import ordermate.database.misc.license.PersistentLicenseManager;
import ordermate.integration.diamondback.DiamondBackIntegrator;
import ordermate.integration.webservice.PassthroughX509TrustManager;
import ordermate.integration.webservice.RestHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class CloudBookingsAction
extends AbstractAction {
    private static final Integer TIMEOUT = 5000;
    private static final String BOOKINGS = "bookings/v1/general/";
    private static final String STORE_INTEGRATION = "/storeIntegration";
    private static final String INTEGRATIONS = "integrations";
    private static final String INTEGRATION = "integration";
    private static final String REDBACK_ID = "redbackId";
    private static final String REQS = "storereq";
    private String baseUrl;
    private String type;
    private long redbackId;
    private RestHelper rest;
    private static final String AUTHORISED = "Authorised";
    private static final String VALUE = "value";
    private static final String LABEL = "label";
    private static final String DESCRIPTION = "description";
    private static final String STORE_ID = "storeId";

    CloudBookingsAction() {
        super("Setup Cloud Bookings");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.startConfiguration();
    }

    private void startConfiguration() {
        CloudBackConfig config = DiamondBackIntegrator.getDiamondBackConfig();
        if (!this.preflightCheck(config)) {
            return;
        }
        this.rest = new RestHelper();
        this.makeBaseUrl(config.getWebConfig());
        if (this.getCurrentConfiguration()) {
            this.beginConfigure();
        }
    }

    private boolean preflightCheck(CloudBackConfig config) {
        boolean proceed;
        if (!config.isEnabled()) {
            Dialogs.showErrorDialog("Not Enabled", "CloudBack for Bookings is set to disabled");
            return false;
        }
        if (StringUtils.isEmpty((String)config.getWebConfig().getUrl())) {
            Dialogs.showErrorDialog("Bad URL", "The URL for Diamondback is empty");
            return false;
        }
        this.redbackId = SystemCurrentInfo.getInstance().getRedbackId();
        if (this.redbackId == 0L) {
            Dialogs.showErrorDialog("Bad RB ID", "The RedBack ID is set to 0 for this store. Cannot proceed.");
            return false;
        }
        return PersistentLicenseManager.getInstance().getLicenseValue(LicenseType.ReservationIntegrationEnabled) == 1 || (proceed = Dialogs.showChoiceDialog("Not Licensed", "You need to have Reservations Integration licensed. Proceed?"));
    }

    private void makeBaseUrl(WebserviceIntegrationConfig config) {
        this.baseUrl = config.getUrl();
        if (!this.baseUrl.endsWith("/")) {
            this.baseUrl = this.baseUrl + "/";
        }
        this.baseUrl = this.baseUrl + BOOKINGS;
    }

    private boolean getCurrentConfiguration() {
        WebResource resource = this.makeResource(this.baseUrl + this.redbackId + STORE_INTEGRATION);
        ClientResponse response = (ClientResponse)resource.get(ClientResponse.class);
        if (response.getStatus() / 100 == 2) {
            String value = (String)response.getEntity(String.class);
            if (StringUtils.isEmpty((String)value)) {
                this.type = this.getType();
                if (!StringUtils.isEmpty((String)this.type)) {
                    return true;
                }
            } else {
                if (value.startsWith("!")) {
                    this.type = value.substring(1);
                    if (Dialogs.showChoiceDialog(value, "Store is set to " + this.type + " but is not yet authorised. Proceed?")) {
                        this.type = this.getType();
                        if (!StringUtils.isEmpty((String)this.type)) {
                            return true;
                        }
                    }
                }
                this.type = value;
                Dialogs.showErrorDialog("Already Configured", "The store is already set and authorised for " + this.type);
            }
        } else {
            this.doBad(response);
        }
        return false;
    }

    private WebResource makeResource(String url) {
        if (this.baseUrl.startsWith("https")) {
            return this.rest.getSslResource(url, (X509TrustManager)new PassthroughX509TrustManager(), TIMEOUT, TIMEOUT);
        }
        return this.rest.getResource(url, TIMEOUT, TIMEOUT);
    }

    private void doBad(ClientResponse response) {
        String entity = (String)response.getEntity(String.class);
        OrderMate.LOG.error("Bad diamondback configuration - " + entity + ": " + response.getStatus());
        Dialogs.showErrorDialog("Bad Response", "Error setting up bookings:" + response.getStatus() + "\r\n" + (entity != null ? entity : "See logs"));
    }

    private String getType() {
        WebResource resource = this.makeResource(this.baseUrl + INTEGRATIONS);
        ClientResponse response = (ClientResponse)resource.get(ClientResponse.class);
        if (response.getStatus() / 100 == 2) {
            String value = (String)response.getEntity(String.class);
            List values = StringUtils.splitToList((String)value, (String)",");
            if (values.size() == 1) {
                return (String)values.get(0);
            }
            return (String)Dialogs.showOptionDialog("Select Bookings Integration", "Please choose the required bookings integration.", values);
        }
        this.doBad(response);
        return null;
    }

    private void beginConfigure() {
        WebResource resource = this.makeResource(this.baseUrl + this.redbackId + STORE_INTEGRATION);
        ClientResponse response = (ClientResponse)(resource = this.rest.addParameter(resource, INTEGRATION, this.type)).put(ClientResponse.class);
        if (response.getStatus() / 100 == 2) {
            String value = (String)response.getEntity(String.class);
            OrderMate.LOG.info(value);
            resource = this.makeResource(this.baseUrl + REQS);
            resource = this.rest.addParameter(resource, REDBACK_ID, "" + this.redbackId);
            response = (ClientResponse)resource.get(ClientResponse.class);
            this.handleInitialResponse(response);
        } else {
            this.doBad(response);
        }
    }

    private void handleInitialResponse(ClientResponse initialResponse) {
        if (initialResponse.getStatus() / 100 == 2) {
            Document doc = CloudBookingsAction.getDoc((String)initialResponse.getEntity(String.class));
            ReqEditorPanel reqPanel = new ReqEditorPanel(doc);
            if (Dialogs.getOkCancelDialogBuilder(reqPanel).setTitle("Input Values").doShow()) {
                reqPanel.save();
                WebResource resource = this.rest.getResource(this.baseUrl + REQS);
                resource = this.rest.addParameter(resource, REDBACK_ID, "" + this.redbackId);
                ClientResponse response = (ClientResponse)resource.type("application/xml").post(ClientResponse.class, (Object)doc);
                String responseString = (String)response.getEntity(String.class);
                OrderMate.LOG.info(responseString);
                if (response.getStatus() / 100 == 2) {
                    boolean success = this.checkSuccess(responseString);
                    if (success) {
                        this.postSuccess();
                        Dialogs.showInfoDialog("Configuration successful", "Cloud Bookings configured, please restart Servermate and all Waitermates for changes to take effect");
                    } else {
                        Dialogs.showInfoDialog("Auth failed", "Cloud Bookings configured, but the credentials appear to be incorrect");
                    }
                } else {
                    Dialogs.showWarningDialog("Configuration unsuccessful", "Cloud Bookings NOT configured, please check logs");
                }
            }
        } else {
            this.doBad(initialResponse);
        }
    }

    private boolean checkSuccess(String entity) {
        Document doc = CloudBookingsAction.getDoc(entity);
        try {
            Element root = (Element)doc.getChildNodes().item(0);
            NodeList nodeList = root.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element nextElement = (Element)nodeList.item(i);
                if (!AUTHORISED.equals(nextElement.getAttribute(LABEL))) continue;
                return Boolean.parseBoolean(nextElement.getAttribute(VALUE));
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Problem reading response from DiamondBack Bookings", (Throwable)ex);
        }
        return false;
    }

    private void postSuccess() {
        FinanceUnit unit;
        SystemProperty props = SystemProperty.getInstance();
        props.setReservationIntegration(ReservationIntegrationType.DIAMONDBACK);
        props.setReservationsEnabled(false);
        props.save();
        Terminal servermate = Terminal.getServerMateTerminal();
        String ip = servermate.getIPAddress();
        Terminal wmt = (Terminal)PersistenceManager.getObject(Terminal.class, (String)Query.select(Terminal.class).equals(Terminal.Properties.TERMINAL_TYPE, (Object)TerminalTypes.WaiterMate).active(Terminal.class).not().equals(Terminal.Properties.ADDRESS, (Object)ip).orderBy(Terminal.Properties.ID).limit(1).toString());
        if (wmt == null) {
            wmt = (Terminal)PersistenceManager.getObject(Terminal.class, (String)Query.select(Terminal.class).equals(Terminal.Properties.TERMINAL_TYPE, (Object)TerminalTypes.WaiterMate).active(Terminal.class).orderBy(Terminal.Properties.ID).limit(1).toString());
        }
        if (wmt != null) {
            wmt.setUnallocatedTableAllowed(true);
            wmt.save();
        }
        if ((unit = (FinanceUnit)PersistenceManager.getObject(FinanceUnit.class, (String)Query.select(FinanceUnit.class).equals(FinanceUnit.Properties.LABEL, (Object)this.type).toString())) == null) {
            unit = new FinanceUnit(this.type, FinanceUnit.WEB_TYPE, false);
            unit.save();
        } else if ("ACTIVE".equals(unit.getSystemState())) {
            unit.setSystemState("ACTIVE");
            unit.save();
        }
    }

    static Document getDoc(String value) {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(new ByteArrayInputStream(value.getBytes()));
            return doc;
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot read Diamondback response", (Throwable)ex);
            return null;
        }
    }

    class ReqEditorPanel
    extends JPanel {
        private Map<JTextField, Node> fieldMap = new HashMap<JTextField, Node>();

        ReqEditorPanel(Document doc) {
            Element root = (Element)doc.getChildNodes().item(0);
            root.setAttribute(CloudBookingsAction.STORE_ID, String.valueOf(SystemCurrentInfo.getInstance().getRedbackId()));
            NodeList nodeList = root.getChildNodes();
            this.setLayout((LayoutManager)new GraphPaperLayout(24, nodeList.getLength()));
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (!(nodeList.item(i) instanceof Element)) continue;
                Element nextNode = (Element)nodeList.item(i);
                if (!nextNode.hasAttribute(CloudBookingsAction.VALUE)) {
                    nextNode.setAttribute(CloudBookingsAction.VALUE, null);
                }
                NamedNodeMap nodeMap = nextNode.getAttributes();
                String label = nodeMap.getNamedItem(CloudBookingsAction.LABEL).getNodeValue();
                label = label.replace(" ", "_").toLowerCase();
                this.add((Component)new JLabel(label), new Rectangle(1, i, 3, 1));
                this.add((Component)new JLabel(nodeMap.getNamedItem(CloudBookingsAction.DESCRIPTION).getNodeValue()), new Rectangle(4, i, 13, 1));
                JTextField valueField = new JTextField();
                Node value = nodeMap.getNamedItem(CloudBookingsAction.VALUE);
                String input = value.getNodeValue();
                if (CloudBookingsAction.AUTHORISED.equals(label)) {
                    valueField.setEnabled(false);
                    try {
                        input = Boolean.parseBoolean(input) ? "Already Authorised" : "Not yet Authorised";
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                valueField.setText(input);
                valueField.setName(label);
                this.fieldMap.put(valueField, value);
                this.add((Component)valueField, new Rectangle(17, i, 6, 1));
            }
        }

        void save() {
            for (Map.Entry<JTextField, Node> entry : this.fieldMap.entrySet()) {
                entry.getValue().setNodeValue(entry.getKey().getText());
            }
        }
    }
}

