/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.advanced.diff;

import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.searchfield.java.ComboSearchField;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import java.util.Collection;
import javax.swing.Action;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.search.ObjectPropertySearch;
import officemate.components.table.AbstractTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import ordermate.database.diff.VersionControl;
import ordermate.database.diff.VersionDiff;
import ordermate.database.searchers.diff.VersionDiffSearcher;
import ordermate.reports.table.AbstractColumnFormat;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class VersionDiffState
extends AbstractTableState<VersionDiff> {
    private EventList<VersionControl> allVersionControls = new BasicEventList();
    private EventList<VersionDiff> versionsList;

    public VersionDiffState() {
        super("Property Versions", null, "Displays current version control information");
        this.allVersionControls.addAll((Collection)PersistenceManager.getObjectList(VersionControl.class, (String)Query.select(VersionControl.class).orderBy(VersionControl.Properties.ID).toString()));
        this.versionsList = new BasicEventList();
    }

    @Override
    protected TableStateCentralArea<VersionDiff> createCentralArea() {
        ColumnTableFormat format = new ColumnTableFormat(new ColumnFormat[]{new AbstractColumnFormat("Class Type", Class.class){

            public Object resolveColumnValue(Object baseObject) {
                VersionDiff version = (VersionDiff)baseObject;
                return version.getClassType().getSimpleName();
            }
        }, new PropertyColumnFormat(VersionDiff.Properties.OBJECT_ID), new AbstractColumnFormat("Changed Property", PropertiedObject.Property.class){

            public Object resolveColumnValue(Object baseObject) {
                VersionDiff version = (VersionDiff)baseObject;
                return version.getChangedProperty().getName();
            }
        }, new PropertyColumnFormat(VersionDiff.Properties.CHANGE_TYPE), new PropertyColumnFormat(VersionDiff.Properties.VERSION_NUMBER)});
        return new PersistentObjectTable<VersionDiff>(this.getObjectList(), format);
    }

    @Override
    public EventList<VersionDiff> getObjectList() {
        return this.versionsList;
    }

    @Override
    protected OfficeMateObjectSearch<VersionDiff> createSearchPanelFactory() {
        VersionDiffSearcher searcher = new VersionDiffSearcher();
        ObjectPropertySearch<VersionDiff> search = new ObjectPropertySearch<VersionDiff>(VersionDiff.class, (ObjectQuerySearcher<VersionDiff>)searcher, this.versionsList);
        ComboSearchField versionControlField = new ComboSearchField("Version Control: ", searcher.getVersionControlFilter(), false, (Action)new RefreshAction((Refreshable)this), this.allVersionControls);
        search.addSearchField((SearchGuiField)versionControlField);
        return search;
    }

    @Override
    protected Class<VersionDiff> getDisplayingType() {
        return VersionDiff.class;
    }

    @Override
    public void refresh() {
        super.refresh();
        this.allVersionControls.clear();
        this.allVersionControls.addAll((Collection)PersistenceManager.getObjectList(VersionControl.class, (String)Query.select(VersionControl.class).orderBy(VersionControl.Properties.ID).toString()));
    }
}

