/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.advanced.exportsales;

import au.com.ordermate.util.StringUtils;
import au.com.ordermate.util.Stringifier;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.EventComboBoxModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import officemate.components.AbstractObjectEditor;
import officemate.components.controls.CheckListComboBox;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.hardware.Terminal;
import ordermate.database.integration.exportsales.OperationalUnitItem;
import ordermate.database.integration.exportsales.SalesExportItem;
import ordermate.database.inventory.InventoryCategory;
import ordermate.gui.FieldPanelBuilder;

public class SalesExportFilterEditor
extends AbstractObjectEditor<SalesExportItem> {
    private JTextField labelField;
    private CheckListComboBox<Terminal> checkListTerminals;
    private List<Terminal> allTerminals;
    private CheckListComboBox<InventoryCategory> checkListInventoryCategories;
    JComboBox opIDComboBox;
    private List<InventoryCategory> allInventoryCategories;
    private List<OperationalUnitItem> allOperationalIDs;
    private CheckListComboBox<SalesLocation> checkListSalesLocations;
    private List<SalesLocation> allSalesLocations;

    public SalesExportFilterEditor(List<Terminal> terminals, List<InventoryCategory> inventoryCategories, List<SalesLocation> salesLocations) {
        this.allTerminals = terminals;
        this.allInventoryCategories = inventoryCategories;
        this.allSalesLocations = salesLocations;
    }

    @Override
    protected void init() {
        super.init();
        FieldPanelBuilder builder = new FieldPanelBuilder(5, 25);
        this.refreshOperationalUnitsList();
        builder.addRow("External Location ID:", (Component)this.opIDComboBox);
        this.checkListTerminals = new CheckListComboBox(new ArrayList(), "All");
        this.checkListTerminals.getComboBox().setName("Terminals");
        builder.addRow("Terminals: ", (Component)this.checkListTerminals.getComboBox());
        this.checkListInventoryCategories = new CheckListComboBox(new ArrayList(), "All");
        this.checkListInventoryCategories.getComboBox().setName("Categories");
        builder.addRow("Categories: ", (Component)this.checkListInventoryCategories.getComboBox());
        this.checkListSalesLocations = new CheckListComboBox(new ArrayList(), "All");
        this.checkListSalesLocations.getComboBox().setName("Sales Locations");
        builder.addRow("Sales Locations: ", (Component)this.checkListSalesLocations.getComboBox());
        JPanel toSet = new JPanel(new BorderLayout());
        toSet.add((Component)builder.getPanel(), "North");
        this.add(toSet);
    }

    public void refreshOperationalUnitsList() {
        this.allOperationalIDs = SalesExportItem.getOperationalIDListFromThirdParty();
        ArrayList<String> areaNames = new ArrayList<String>();
        if (this.allOperationalIDs == null) {
            if (this.opIDComboBox == null) {
                this.opIDComboBox = new JComboBox<Object>(areaNames.toArray());
            }
            return;
        }
        for (OperationalUnitItem op : this.allOperationalIDs) {
            areaNames.add(op.getId().toString() + " - " + op.getOperationalUnitName());
        }
        if (this.opIDComboBox == null) {
            this.opIDComboBox = new JComboBox<Object>(areaNames.toArray());
        } else {
            this.opIDComboBox.removeAllItems();
            for (String area : areaNames) {
                this.opIDComboBox.addItem(area);
            }
        }
    }

    public void refreshEditor() {
        this.checkListTerminals.setSelectedElements(new ArrayList());
        this.checkListInventoryCategories.setSelectedElements(new ArrayList());
    }

    private List<Terminal> getTerminalsToList() {
        ArrayList<Terminal> terminals = new ArrayList<Terminal>();
        for (Terminal term : this.allTerminals) {
            terminals.add(term);
        }
        return terminals;
    }

    private List<InventoryCategory> getCategoriesToList() {
        ArrayList<InventoryCategory> categories = new ArrayList<InventoryCategory>();
        for (InventoryCategory cate : this.allInventoryCategories) {
            categories.add(cate);
        }
        return categories;
    }

    private List<SalesLocation> getSalesLocationsToList() {
        ArrayList<SalesLocation> salesLocations = new ArrayList<SalesLocation>();
        for (SalesLocation salesLocation : this.allSalesLocations) {
            salesLocations.add(salesLocation);
        }
        return salesLocations;
    }

    private List<SalesLocation> getSelectedSalesLocations(SalesExportItem value) {
        String salesLocationsStr = value.getSalesLocations();
        if (StringUtils.isEmpty((String)salesLocationsStr)) {
            return null;
        }
        List salesLocationIDs = StringUtils.splitToList((String)salesLocationsStr, (String)"\\s*,\\s*");
        ArrayList<SalesLocation> salesLocations = new ArrayList<SalesLocation>();
        for (SalesLocation salesLocation : this.allSalesLocations) {
            if (!salesLocationIDs.contains(salesLocation.getID().toString())) continue;
            salesLocations.add(salesLocation);
        }
        return salesLocations;
    }

    private List<Terminal> getSelectedTerminals(SalesExportItem value) {
        String terminalsStr = value.getTerminals();
        if (StringUtils.isEmpty((String)terminalsStr)) {
            return null;
        }
        List terminalIDs = StringUtils.splitToList((String)terminalsStr, (String)"\\s*,\\s*");
        ArrayList<Terminal> terminals = new ArrayList<Terminal>();
        for (Terminal term : this.allTerminals) {
            if (!terminalIDs.contains(term.getID().toString())) continue;
            terminals.add(term);
        }
        return terminals;
    }

    private List<InventoryCategory> getSelectedCategories(SalesExportItem value) {
        String inventoryCategoriesStr = value.getCategories();
        if (StringUtils.isEmpty((String)inventoryCategoriesStr)) {
            return null;
        }
        List categoryIDs = StringUtils.splitToList((String)inventoryCategoriesStr, (String)"\\s*,\\s*");
        ArrayList<InventoryCategory> categories = new ArrayList<InventoryCategory>();
        for (InventoryCategory cate : this.allInventoryCategories) {
            if (!categoryIDs.contains(cate.getID().toString())) continue;
            categories.add(cate);
        }
        return categories;
    }

    @Override
    public void setObject(SalesExportItem value) {
        this.checkListTerminals.setModel(new EventComboBoxModel(GlazedLists.eventList(this.getTerminalsToList())));
        List<Terminal> terminals = this.getSelectedTerminals(value);
        if (terminals != null) {
            this.checkListTerminals.setSelectedElements(terminals);
        }
        this.checkListInventoryCategories.setModel(new EventComboBoxModel(GlazedLists.eventList(this.getCategoriesToList())));
        List<InventoryCategory> categories = this.getSelectedCategories(value);
        if (categories != null) {
            this.checkListInventoryCategories.setSelectedElements(categories);
        }
        this.checkListSalesLocations.setModel(new EventComboBoxModel(GlazedLists.eventList(this.getSalesLocationsToList())));
        List<SalesLocation> salesLocations = this.getSelectedSalesLocations(value);
        if (salesLocations != null) {
            this.checkListSalesLocations.setSelectedElements(salesLocations);
        }
        int index = 0;
        if (this.allOperationalIDs != null) {
            for (OperationalUnitItem op : this.allOperationalIDs) {
                if (op.getId().equals(value.getExternalLocationID())) {
                    this.opIDComboBox.setSelectedIndex(index);
                    break;
                }
                ++index;
            }
        }
        super.setObject(value);
    }

    public void saveObjectLocal() {
        ArrayList<Terminal> selectedTerminals = new ArrayList<Terminal>(this.checkListTerminals.getSelectedElements());
        String terminalsStr = StringUtils.mergeToStringWithSeparator(selectedTerminals, (String)",", (Stringifier)new Stringifier<Terminal>(){

            public String stringify(Terminal object) {
                return object.getID().toString();
            }
        });
        ((SalesExportItem)this.getObject()).setTerminals(terminalsStr);
        ArrayList<InventoryCategory> selectedCategories = new ArrayList<InventoryCategory>(this.checkListInventoryCategories.getSelectedElements());
        String inventoryCategoriesStr = StringUtils.mergeToStringWithSeparator(selectedCategories, (String)",", (Stringifier)new Stringifier<InventoryCategory>(){

            public String stringify(InventoryCategory object) {
                return object.getID().toString();
            }
        });
        ((SalesExportItem)this.getObject()).setCategories(inventoryCategoriesStr);
        ArrayList<SalesLocation> selectedSalesLocations = new ArrayList<SalesLocation>(this.checkListSalesLocations.getSelectedElements());
        String salesLocationsStr = StringUtils.mergeToStringWithSeparator(selectedSalesLocations, (String)",", (Stringifier)new Stringifier<SalesLocation>(){

            public String stringify(SalesLocation object) {
                return object.getID().toString();
            }
        });
        ((SalesExportItem)this.getObject()).setSalesLocations(salesLocationsStr);
        if (this.allOperationalIDs != null) {
            ((SalesExportItem)this.getObject()).setExternalLocationID(this.allOperationalIDs.get(this.opIDComboBox.getSelectedIndex()).getId());
        }
    }

    @Override
    public void saveObject() {
        this.saveObjectLocal();
        super.saveObject();
    }
}

