/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.advanced.financeunit;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.glazedlists.GlazedListUtils;
import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.search.SearchFilterI;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.searchfield.java.ComboSearchField;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.Component;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.search.ObjectPropertySearch;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.EditablePropertyColumnFormat;
import officemate.components.tableformat.renderers.AutoCompleteComboCellEditor;
import officemate.components.tableformat.renderers.NotNullCellEditorWrapper;
import officemate.screens.setup.configuration.advanced.financeunit.FinanceUnitEditorPanel;
import ordermate.database.finance.FinanceAccountingGroup;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.finance.transactions.KickCashdrawer;
import ordermate.database.integration.adyen.AdyenIntegrationConfig;
import ordermate.database.users.User;
import ordermate.integration.eftpos.adyen.AdyenUtils;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;
import org.jdesktop.swingx.table.NumberEditorExt;
import org.jdesktop.swingx.table.TableColumnExt;

public class FinanceUnitState
extends AbstractEditableTableState<FinanceUnit> {
    private boolean adyenConfigured = false;
    private boolean adyenPermissions = false;
    private EventList<FinanceAccountingGroup> accountingGroups;
    private static final String[] DISREGARD_LIST = new String[]{"Gift Voucher", "Tip", "Expense", "Purchase", "Over charge", "Loyalty", "Float", "Export", "Account", "Debtor Adjustment"};

    @Override
    protected OfficeMateObjectSearch<FinanceUnit> createSearchPanelFactory() {
        return new PaymentSearch();
    }

    @Override
    protected boolean canCreateOrDelete() {
        return true;
    }

    @Override
    protected ObjectEditor<FinanceUnit> createObjectEditor() {
        return new FinanceUnitEditorPanel();
    }

    @Override
    public String getTypeName() {
        return "Payment Types";
    }

    @Override
    protected TableStateCentralArea<FinanceUnit> createCentralArea() {
        this.accountingGroups = new BasicEventList();
        this.accountingGroups.addAll((Collection)PersistenceManager.getObjectList(FinanceAccountingGroup.class, (String)Query.select(FinanceAccountingGroup.class).toString()));
        ColumnTableFormat format = new ColumnTableFormat(new ColumnFormat[]{new PropertyColumnFormat(FinanceUnit.Properties.TYPE), new PropertyColumnFormat(FinanceUnit.Properties.LABEL), new EditablePropertyColumnFormat(FinanceUnit.Properties.SURCHARGE).setCustomEditor(new AdyenSurchargeColumnEditor((TableCellEditor)new NumberEditorExt((NumberFormat)new DecimalFormat("")), 0.0)).setCustomRenderer(new AdyenSurchargeRenderer()).setFormatter((Format)new DecimalFormat("0.0#%")).setName("Surcharge %"), new EditablePropertyColumnFormat(FinanceUnit.Properties.KICK_CASHDRAWER).setCustomEditor((TableCellEditor)((Object)new AutoCompleteComboCellEditor(GlazedLists.eventListOf((Object[])KickCashdrawer.values()), false))), new EditablePropertyColumnFormat(FinanceUnit.Properties.SKIMMABLE).setName("Skimmable"), new EditablePropertyColumnFormat(FinanceUnit.Properties.ACCOUNTING_GROUP).setCustomEditor((TableCellEditor)((Object)new AutoCompleteComboCellEditor(this.accountingGroups, true))), new PropertyColumnFormat(FinanceUnit.Properties.USES_EFTPOS), new EditablePropertyColumnFormat(FinanceUnit.Properties.SYSTEM_STATE).setCustomEditor((TableCellEditor)((Object)new AutoCompleteComboCellEditor(GlazedLists.eventListOf((Object[])new String[]{"ACTIVE", "INACTIVE"}), false)))});
        PersistentObjectTable<FinanceUnit> table = new PersistentObjectTable<FinanceUnit>(this.getObjectList(), format);
        return table;
    }

    @Override
    protected void onStart() {
        super.onStart();
        User user = GuiApp.getAppComplex().getApplicationSecurity().getUser();
        TableColumnExt sysStateColumn = this.getCentralArea().getTable().getColumnExt((Object)FinanceUnit.Properties.SYSTEM_STATE);
        boolean isAdmin = user != null && user.getPermissionGroup().getLevel() > 5;
        sysStateColumn.setVisible(isAdmin);
        sysStateColumn.setEditable(isAdmin);
        this.adyenConfigured = AdyenUtils.hasAdyenConfigured();
        this.adyenPermissions = AdyenUtils.isTerminalSettingsEditAllowed((User)this.getUser());
    }

    @Override
    protected Class<FinanceUnit> getDisplayingType() {
        return FinanceUnit.class;
    }

    @Override
    public void refresh() {
        GlazedListUtils.setAsList(this.accountingGroups, (Collection)PersistenceManager.getObjectList(FinanceAccountingGroup.class, (String)Query.select(FinanceAccountingGroup.class).orderBy(FinanceAccountingGroup.Properties.LABEL).toString()));
        super.refresh();
    }

    @Override
    public void doEditAction() {
        FinanceUnit selectedUnit = (FinanceUnit)this.getCentralArea().getSelectedObject();
        if (selectedUnit.isUserdefined()) {
            this.doEdit(this.getCentralArea().getSelectedObject());
        } else {
            Dialogs.showErrorDialog("Warning", "You cannot edit the payment type");
        }
    }

    @Override
    public void doDeleteAction() {
        List selected = this.getCentralArea().getAllSelectedObjects();
        for (FinanceUnit selectedUnit : selected) {
            if (selectedUnit.isUserdefined()) {
                this.doDelete(selected);
                continue;
            }
            Dialogs.showErrorDialog("Warning", "You cannot delete the payment type");
        }
    }

    @Override
    public void gotObjectDoubleClicked(FinanceUnit toEdit) {
        if (toEdit.isUserdefined()) {
            this.doEdit(toEdit);
        }
    }

    @Override
    public void gotObjectEdited(FinanceUnit editedObject) {
        if (editedObject.getType().equals("MOTO") && !AdyenIntegrationConfig.getInstance().isConfigured()) {
            Dialogs.showErrorDialog("Not Allowed", "MOTO is only available with Oolio Pay configured");
            return;
        }
        super.gotObjectEdited(editedObject);
    }

    public class AdyenSurchargeRenderer
    extends DefaultTableCellRenderer
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (FinanceUnitState.this.getObjectList().get(row) != null && FinanceUnitState.this.adyenConfigured && !FinanceUnitState.this.adyenPermissions) {
                this.setEnabled(!((FinanceUnit)FinanceUnitState.this.getObjectList().get(row)).isUsesEftpos());
            } else {
                this.setEnabled(true);
            }
            return super.getTableCellRendererComponent(table, AdyenUtils.makePercentageString((Double)((Double)value)), isSelected, hasFocus, row, column);
        }
    }

    public class AdyenSurchargeColumnEditor
    extends NotNullCellEditorWrapper {
        JLabel label;

        public AdyenSurchargeColumnEditor(TableCellEditor theDelegate, Object theNullValue) {
            super(theDelegate, theNullValue);
            this.label = new JLabel();
            this.label.setEnabled(false);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (FinanceUnitState.this.getObjectList().get(row) != null && FinanceUnitState.this.adyenConfigured && !FinanceUnitState.this.adyenPermissions && ((FinanceUnit)FinanceUnitState.this.getObjectList().get(row)).isUsesEftpos()) {
                this.label.setText(((JTextField)super.getTableCellEditorComponent(table, value, isSelected, row, column)).getText());
                return this.label;
            }
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }

    class PaymentTypeSearcher
    extends PropertySearcher<FinanceUnit> {
        private ISingleValueSearchFilter<String> stateFilter;

        public PaymentTypeSearcher() {
            super(FinanceUnit.class);
            this.stateFilter = new ObjectSearchFilter(FinanceUnit.Properties.SYSTEM_STATE);
            this.stateFilter.setSearchValue((Object)"ACTIVE");
            this.addSearchFilter((SearchFilterI)this.stateFilter);
        }

        protected ObjectQuery getBaseQuery() {
            ObjectQuery query = Query.select(FinanceUnit.class);
            query.not().wherePropertyIn(FinanceUnit.Properties.LABEL, (Object[])DISREGARD_LIST);
            query.orderBy(FinanceUnit.Properties.TYPE).orderBy(FinanceUnit.Properties.LABEL);
            return query;
        }

        public ISingleValueSearchFilter<String> getStateFilter() {
            return this.stateFilter;
        }
    }

    class PaymentSearch
    extends ObjectPropertySearch<FinanceUnit> {
        public PaymentSearch() {
            super(FinanceUnit.class);
            this.setupFields();
        }

        private void setupFields() {
            RefreshAction refresh = new RefreshAction((Refreshable)this);
            PaymentTypeSearcher mySearcher = (PaymentTypeSearcher)this.getPropertySearcher();
            BasicEventList stateList = new BasicEventList();
            stateList.add((Object)"ACTIVE");
            stateList.add((Object)"INACTIVE");
            this.addSearchField((SearchGuiField)new ComboSearchField("State", mySearcher.getStateFilter(), true, (Action)refresh, (EventList)stateList));
        }

        @Override
        protected ObjectQuerySearcher<FinanceUnit> constructPropertySearcher() {
            return new PaymentTypeSearcher();
        }
    }
}

