/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.advanced.salesexport;

import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.util.image.IconLoader;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.AbstractObjectEditor;
import officemate.components.ObjectEditorState;
import officemate.components.strategy.DeferredSaveStrategy;
import officemate.components.strategy.SaveStrategyFactory;
import officemate.components.strategy.StrategySaveCancelListener;
import officemate.screens.setup.configuration.advanced.salesexport.DeputyAuthTask;
import officemate.screens.setup.configuration.advanced.salesexport.SalesExportIntegrationEditor;
import officemate.screens.setup.configuration.advanced.salesexport.SalesExporterAuthTask;
import officemate.screens.setup.configuration.advanced.salesexport.TandaAuthTask;
import officemate.screens.setup.configuration.advanced.salesexport.TandaDatastreamTask;
import ordermate.database.integration.exportsales.ExportSalesHelper;
import ordermate.database.integration.exportsales.ExportSalesIntegration;
import ordermate.database.integration.exportsales.SalesExporterType;
import ordermate.database.schedule.Schedule;

public class SalesExportIntegrationState
extends ObjectEditorState<ExportSalesIntegration>
implements StrategySaveCancelListener {
    private Action connect;
    private Action disconnect;
    private Action createDatastream;

    public SalesExportIntegrationState() {
        super("Sales Export Integration", null, "Setup and modify the sales export integration");
        DeferredSaveStrategy saveStrategy = SaveStrategyFactory.getDeferredSaveStrategy((Refreshable)this);
        this.setSaveStrategy(saveStrategy);
        saveStrategy.addSaveCancelListener(this);
        this.connect = new AbstractAction("Authorise", IconLoader.get((String)"/officemate/images/resync.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SalesExporterAuthTask task;
                ExportSalesIntegration integration = ExportSalesHelper.getIntegration();
                if (SalesExporterType.Deputy.equals((Object)integration.getExporterType())) {
                    task = new DeputyAuthTask();
                } else if (SalesExporterType.Tanda.equals((Object)integration.getExporterType())) {
                    task = new TandaAuthTask();
                } else {
                    Dialogs.showMessageDialog("Unknown Authorisation", "Cannot authorise with type " + integration.getExporterType());
                    return;
                }
                task.run();
            }
        };
        this.disconnect = new AbstractAction("Disconnect", IconLoader.get((String)"/ordermate/images/button_cancel.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean yes = Dialogs.showChoiceDialog("Confirm Disconnect", "Are you sure you wish to disconnect from the Integration?");
                if (yes) {
                    ExportSalesIntegration integration = (ExportSalesIntegration)SalesExportIntegrationState.this.getObjectEditor().getObject();
                    integration.setEnabled(false);
                    integration.setToken(null);
                    integration.save();
                    Schedule schedule = ExportSalesHelper.getSalesExportSchedule();
                    schedule.setRecurrence("");
                    schedule.save();
                    SalesExportIntegrationState.this.refresh();
                }
            }
        };
        this.addAction(this.connect);
        this.addAction(this.disconnect);
        this.createDatastream = new AbstractAction("Create DataStream", IconLoader.get((String)"/ordermate/images/linkOne.png")){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ExportSalesIntegration integration = (ExportSalesIntegration)SalesExportIntegrationState.this.getObjectEditor().getObject();
                if (integration.getToken() == null) {
                    Dialogs.showInfoDialog("No Token", "Please have a valid token before you proceed");
                } else if (SalesExporterType.Tanda.equals((Object)integration.getExporterType())) {
                    if (Dialogs.showChoiceDialog("Create Datastream?", "This will attempt to make a new datastream. Proceed?")) {
                        TandaDatastreamTask task = new TandaDatastreamTask();
                        Dialogs.showProgressDialog((AbstractTask)task);
                    }
                } else {
                    Dialogs.showInfoDialog("Tanda Only", "Datastreams are only available for Tanda");
                }
            }
        };
        this.addAction(this.createDatastream);
    }

    @Override
    protected ExportSalesIntegration acquireObject() {
        return ExportSalesHelper.getIntegration();
    }

    @Override
    protected AbstractObjectEditor<ExportSalesIntegration> createObjectEditor() {
        return new SalesExportIntegrationEditor();
    }

    @Override
    public void preSave() {
        this.getObjectEditor().saveObject();
    }

    @Override
    public void preCancel() {
        this.getObjectEditor().revertObject();
    }

    @Override
    public void postSave() {
    }
}

