/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.advanced.salesexport;

import au.com.ordermate.guicore.task.AbstractGuiTask;
import com.sun.jersey.api.client.WebResource;
import java.awt.Desktop;
import java.io.IOException;
import ordermate.OrderMate;
import ordermate.database.integration.exportsales.ExportSalesHelper;
import ordermate.database.integration.exportsales.ExportSalesIntegration;
import ordermate.database.integration.exportsales.SalesExporterType;
import ordermate.integration.webservice.RestHelper;

public abstract class SalesExporterAuthTask
extends AbstractGuiTask {
    private final Integer TIMEOUT = 10000;
    private final SalesExporterType type;

    public SalesExporterAuthTask(SalesExporterType type) {
        this.type = type;
    }

    public String getName() {
        return "Authorise Sales Exporter";
    }

    protected int getTotalSubTasks() {
        return 1;
    }

    protected void doGuiTask() throws Exception {
        try {
            Desktop.getDesktop().browse(this.getResource(new RestHelper()).getURI());
        }
        catch (IOException ex) {
            OrderMate.LOG.error("Cannot load up browser to accept Sales Exporter Authority", (Throwable)ex);
        }
    }

    protected WebResource getResource(RestHelper rest) {
        ExportSalesIntegration exportIntegration = ExportSalesHelper.getIntegration();
        String URL2 = this.formUrl(exportIntegration);
        WebResource resource = rest.getResource(URL2, this.TIMEOUT, this.TIMEOUT);
        return resource;
    }

    protected String formUrl(ExportSalesIntegration exportIntegration) {
        return "https://" + exportIntegration.getSubdomain() + "/api/oath/token";
    }
}

