/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.advanced.taxcode;

import ca.odell.glazedlists.GlazedLists;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import officemate.components.AbstractObjectEditor;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.finance.tax.TaxCode;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.binding.validators.CompoundValidator;
import ordermate.gui.binding.validators.NotEmptyValidator;
import ordermate.gui.binding.validators.RequiredStringValidator;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.Validator;

public class TaxCodeEditor
extends AbstractObjectEditor<TaxCode> {
    private JCheckBox accountingBox;
    private JCheckBox defaultBox;

    public TaxCodeEditor() {
        this.setupComponents();
    }

    private void setupComponents() {
        FieldPanelBuilder builder = new FieldPanelBuilder();
        this.getBindings().setStrategy(AutoBinding.UpdateStrategy.READ_WRITE);
        ArrayList<Object> validators = new ArrayList<Object>();
        validators.add(new NotEmptyValidator());
        validators.add(new RequiredStringValidator("+", false));
        CompoundValidator validator = new CompoundValidator(CompoundValidator.CompoundStyle.AND, validators);
        builder.addRow("Code", (Component)this.setupTextField(TaxCode.Properties.CODE, 10, (Validator)validator));
        builder.addRow("Rate", (Component)this.setupNumberField(TaxCode.Properties.RATE, 10, new Double(0.0), new Double(100.0), "0.0#%"));
        builder.addRow("Description", (Component)this.setupTextField(TaxCode.Properties.DESCRIPTION, 20, (Validator)new NotEmptyValidator()));
        builder.addRow("Ext Acc ID", (Component)this.setupTextField(TaxCode.Properties.EXT_ACC_ID, 10, (Validator)new NotEmptyValidator()));
        builder.addRow("System State", (Component)this.setupComboBox(TaxCode.Properties.SYSTEM_STATE, GlazedLists.eventListOf((Object[])SystemState.defaultEditableSystemStates.values().toArray())));
        builder.addRow("Sequence", (Component)this.setupIntSpinner(TaxCode.Properties.SEQUENCE, 1, 0, null, 1, 10));
        this.defaultBox = this.setupCheckBox(TaxCode.Properties.DEFAULT_CODE);
        builder.addRow("Is Default?", (Component)this.defaultBox);
        this.accountingBox = new JCheckBox();
        this.accountingBox.setEnabled(false);
        builder.addRow("Accounting", (Component)this.accountingBox);
        this.add(builder.getPanel());
    }

    @Override
    public void setObject(TaxCode code) {
        super.setObject(code);
        this.accountingBox.setSelected(code.isAccounting());
        this.defaultBox.setEnabled(!code.isAccounting());
    }
}

