/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.advanced.taxcode;

import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.util.image.IconLoader;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.Icon;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.screens.setup.configuration.advanced.taxcode.TaxCodeEditor;
import ordermate.database.finance.tax.TaxCode;
import ordermate.database.users.AllPermissions;
import ordermate.integration.finance.myob.mapping.FinanceExportStyle;
import ordermate.integration.finance.taxcodes.DefaultTaxCodesManager;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class TaxCodeState
extends AbstractEditableTableState<TaxCode> {
    public TaxCodeState() {
        super("Tax Codes", AllPermissions.GOD_ONLY, "Add, edit and delete tax codes");
        this.addAction((Action)((Object)new ApplyExternalTaxCodeDefaults()));
    }

    @Override
    protected ObjectEditor<TaxCode> createObjectEditor() {
        return new TaxCodeEditor();
    }

    @Override
    public String getTypeName() {
        return "Tax Codes";
    }

    @Override
    protected TableStateCentralArea<TaxCode> createCentralArea() {
        ColumnTableFormat format = new ColumnTableFormat(new ColumnFormat[]{new PropertyColumnFormat(TaxCode.Properties.CODE), new PropertyColumnFormat(TaxCode.Properties.RATE), new PropertyColumnFormat(TaxCode.Properties.DESCRIPTION), new PropertyColumnFormat(TaxCode.Properties.EXT_ACC_ID), new PropertyColumnFormat(TaxCode.Properties.SYSTEM_STATE), new PropertyColumnFormat(TaxCode.Properties.DEFAULT_CODE), new PropertyColumnFormat(TaxCode.Properties.ACCOUNTING), new PropertyColumnFormat(TaxCode.Properties.SEQUENCE)});
        PersistentObjectTable<TaxCode> table = new PersistentObjectTable<TaxCode>(this.getObjectList(), format);
        return table;
    }

    @Override
    protected Class<TaxCode> getDisplayingType() {
        return TaxCode.class;
    }

    private final class ApplyExternalTaxCodeDefaults
    extends BasicAction {
        public ApplyExternalTaxCodeDefaults() {
            super("Apply Default Ext IDs", (Icon)IconLoader.get((String)"/officemate/images/calculate.png"), "Applies default Ext Acc ID's for the selected Accounting Integration.");
        }

        public void actionPerformed(ActionEvent e) {
            FinanceExportStyle choosenAccInt = (FinanceExportStyle)Dialogs.showOptionDialog("Default Tax Codes", "Select the Accounting Integration that you wish to set the default Ext Acc ID's for:", FinanceExportStyle.getMap().values());
            if (choosenAccInt != null) {
                DefaultTaxCodesManager.applyDefaultTaxCodes((FinanceExportStyle)choosenAccInt);
                TaxCodeState.this.refresh();
                Dialogs.showMessageDialog("Default Tax Code", "Default Ext Acc ID's where updated successfully for: " + choosenAccInt);
            }
        }
    }
}

