/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.advanced.webresource;

import au.com.ordermate.glazedlists.GlazedListUtils;
import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.util.Collection;
import javax.swing.table.TableCellEditor;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.search.ObjectPropertySearch;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.EditablePropertyColumnFormat;
import officemate.components.tableformat.renderers.AutoCompleteComboCellEditor;
import ordermate.database.config.webresource.WebResource;
import ordermate.database.config.webresource.WebResourceLogConfig;
import ordermate.database.dbconstants.SystemState;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class WebResourceState
extends AbstractEditableTableState<WebResource> {
    private EventList<WebResourceLogConfig> logConfigs;

    public WebResourceState() {
        super("Resources", null, "Web Resources", null);
    }

    @Override
    protected ObjectEditor<WebResource> createObjectEditor() {
        return null;
    }

    @Override
    public String getTypeName() {
        return "Web Resource";
    }

    @Override
    protected OfficeMateObjectSearch<WebResource> createSearchPanelFactory() {
        PropertySearcher<WebResource> searcher = new PropertySearcher<WebResource>(WebResource.class){

            protected ObjectQuery getBaseQuery() {
                return Query.select(WebResource.class).orderBy(WebResource.Properties.RESOURCE_TYPE);
            }
        };
        ObjectPropertySearch<WebResource> search = new ObjectPropertySearch<WebResource>(WebResource.class, (ObjectQuerySearcher<WebResource>)searcher, (EventList<WebResource>)new BasicEventList());
        return search;
    }

    @Override
    protected TableStateCentralArea<WebResource> createCentralArea() {
        this.logConfigs = new BasicEventList();
        this.logConfigs.addAll((Collection)PersistenceManager.getObjectList(WebResourceLogConfig.class, (String)Query.select(WebResourceLogConfig.class).toString()));
        ColumnTableFormat format = new ColumnTableFormat();
        format.addColumn((ColumnFormat)new PropertyColumnFormat(WebResource.Properties.RESOURCE_TYPE));
        format.addColumn(new EditablePropertyColumnFormat(WebResource.Properties.SYSTEM_STATE).setCustomEditor((TableCellEditor)((Object)new AutoCompleteComboCellEditor(GlazedLists.eventList(SystemState.defaultEditableSystemStates.values())))));
        format.addColumn((ColumnFormat)new PropertyColumnFormat((PropertiedObject.Property)WebResource.Properties.ACTUAL_CONTEXT));
        format.addColumn(new EditablePropertyColumnFormat(WebResource.Properties.SECURE));
        format.addColumn(new EditablePropertyColumnFormat(WebResource.Properties.IP_RESTRICTED));
        format.addColumn(new EditablePropertyColumnFormat(WebResource.Properties.WHITE_LIST));
        format.addColumn((ColumnFormat)new EditablePropertyColumnFormat(WebResource.Properties.LOG_CONFIG).setCustomEditor((TableCellEditor)((Object)new AutoCompleteComboCellEditor(this.logConfigs, false))).setName("Log Level"));
        PersistentObjectTable<WebResource> table = new PersistentObjectTable<WebResource>(this.getObjectList(), format);
        return table;
    }

    @Override
    protected Class<WebResource> getDisplayingType() {
        return WebResource.class;
    }

    @Override
    public boolean canCreateOrDelete() {
        return false;
    }

    @Override
    public void refresh() {
        GlazedListUtils.setAsList(this.logConfigs, (Collection)PersistenceManager.getObjectList(WebResourceLogConfig.class, (String)Query.select(WebResourceLogConfig.class).toString()));
        super.refresh();
    }
}

