/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.advanced.webresource;

import au.com.ordermate.persistence.PersistenceManager;
import ca.odell.glazedlists.GlazedLists;
import java.awt.Component;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import officemate.components.AbstractObjectEditor;
import officemate.screens.setup.configuration.advanced.webresource.WebResourceUserLinkEditor;
import ordermate.database.config.webresource.WebResourceUser;
import ordermate.database.dbconstants.SystemState;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.binding.validators.NotEmptyValidator;
import org.jdesktop.beansbinding.Validator;

public class WebResourceUserEditor
extends AbstractObjectEditor<WebResourceUser> {
    private DefaultComboBoxModel groupModel;
    private JLabel lastAccess;
    private WebResourceUserLinkEditor linkEditor;

    public WebResourceUserEditor() {
        this.setupComponents();
    }

    private void setupComponents() {
        FieldPanelBuilder builder = new FieldPanelBuilder();
        this.groupModel = new DefaultComboBoxModel();
        JComboBox box = this.setupComboBox(WebResourceUser.Properties.GROUP, this.groupModel, (Validator)new NotEmptyValidator());
        box.setEditable(true);
        builder.addRow("Group", (Component)box, "Can be any group to help identify this user.");
        JTextField field = this.setupTextField(WebResourceUser.Properties.LABEL, 10);
        builder.addRow("Label", (Component)field, "The general label of this user. This is not the Username.");
        field = this.setupTextField(WebResourceUser.Properties.USERNAME, 10, (Validator)new NotEmptyValidator());
        builder.addRow("User Name", (Component)field, "This is a unique identifier of the user amongst other users. This is what is passed to the webservice.");
        field = this.setupPasswordField(WebResourceUser.Properties.PASSWORD, 10);
        builder.addRow("Password", (Component)field, "The password for this user.");
        box = this.setupComboBox(WebResourceUser.Properties.SYSTEM_STATE, GlazedLists.eventList(SystemState.defaultEditableSystemStates.values()));
        builder.addRow("State", (Component)box, "The ACTIVE or INACTIVE state for this user.");
        this.lastAccess = new JLabel("Never");
        builder.addRow("Last Accessed", (Component)this.lastAccess);
        this.add(builder.getPanel());
        this.linkEditor = new WebResourceUserLinkEditor();
        this.add(this.linkEditor.getComponent());
    }

    @Override
    public void setObject(WebResourceUser user) {
        Object[][] values = PersistenceManager.getPersistenceDelegate().executeQuery("SELECT DISTINCT config_web_resource_user.resource_group FROM config_web_resource_user", null);
        this.groupModel.removeAllElements();
        for (Object[] nextPiece : values) {
            this.groupModel.addElement(nextPiece[0]);
        }
        Date lastAccessed = user == null || user.getLastAccessed() == null ? null : user.getLastAccessed();
        this.lastAccess.setText(lastAccessed == null ? "Never" : DateFormat.getDateTimeInstance().format(lastAccessed));
        this.linkEditor.setObject(user);
        super.setObject(user);
    }
}

