/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.advanced.webresource;

import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.util.image.IconLoader;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import officemate.adminkit.dialogs.OfficeMateGuiHandler;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.search.ObjectPropertySearch;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.screens.setup.configuration.advanced.webresource.WebResourceUserEditor;
import ordermate.database.config.webresource.WebResourceUser;
import ordermate.database.config.webresource.WebResourceUserLink;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.integration.eftpos.adyen.AdyenIntegrationProcessor;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class WebResourceUserState
extends AbstractEditableTableState<WebResourceUser> {
    public WebResourceUserState() {
        AbstractAction cloneAction = new AbstractAction("Clone", IconLoader.get((String)"/officemate/images/copy.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebResourceUserState.this.doClone((WebResourceUser)WebResourceUserState.this.getCentralArea().getSelectedObject());
            }
        };
        AbstractAction generateUserAction = new AbstractAction("Generate User", IconLoader.get((String)"/officemate/images/copy.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebResourceUserState.this.doGenerateUser();
            }
        };
        this.addSelectionDependentAction(cloneAction);
        this.addAction(generateUserAction);
    }

    private void doClone(WebResourceUser user) {
        if (user == null) {
            return;
        }
        WebResourceUser newUser = new WebResourceUser(user.getLabel() + " (Copy)");
        newUser.setUsername(user.getUsername() + System.currentTimeMillis() % 10000L);
        newUser.setPassword(user.getPassword());
        newUser.setSystemState(user.getSystemState());
        newUser.setGroup(user.getGroup());
        for (WebResourceUserLink link : user.getLinks()) {
            WebResourceUserLink newLink = new WebResourceUserLink(link.getResource(), newUser);
            newUser.getLinks().add(newLink);
        }
        newUser.save();
        this.refresh();
    }

    private void doGenerateUser() {
        String defaultUserString;
        WebResourceUser existingDefaultUser = WebResourceUser.getExistingDefaultUser();
        if (existingDefaultUser == null) {
            String pwd = AdyenIntegrationProcessor.getInstance().getDefaultUserPwdFromGreenBack();
            if (pwd != null && pwd.length() > 8) {
                defaultUserString = "user has been generated in GreenBack";
            } else if (pwd != null && pwd.length() <= 8) {
                long redbackId = SystemCurrentInfo.getInstance().getRedbackId();
                String email = String.valueOf(redbackId) + "_oolio@oolio.com";
                defaultUserString = "";
                defaultUserString = defaultUserString + " User Name: \n" + email;
                defaultUserString = defaultUserString + "\nPassword: \n" + pwd;
            } else {
                defaultUserString = "generate user in redback failed";
            }
        } else {
            defaultUserString = "user has been generated in officemate";
        }
        new OfficeMateGuiHandler().displayOkDialog("Default User Details ", defaultUserString);
        this.refresh();
    }

    @Override
    protected ObjectEditor<WebResourceUser> createObjectEditor() {
        return new WebResourceUserEditor();
    }

    @Override
    protected WebResourceUser createNewObject() {
        WebResourceUser newUser = new WebResourceUser("New User");
        return newUser;
    }

    @Override
    public String getTypeName() {
        return "Web Resource User";
    }

    @Override
    protected OfficeMateObjectSearch<WebResourceUser> createSearchPanelFactory() {
        PropertySearcher<WebResourceUser> searcher = new PropertySearcher<WebResourceUser>(WebResourceUser.class){

            protected ObjectQuery getBaseQuery() {
                return Query.select(WebResourceUser.class).orderBy(WebResourceUser.Properties.GROUP).orderBy(WebResourceUser.Properties.LABEL);
            }
        };
        ObjectPropertySearch<WebResourceUser> search = new ObjectPropertySearch<WebResourceUser>(WebResourceUser.class, (ObjectQuerySearcher<WebResourceUser>)searcher, (EventList<WebResourceUser>)new BasicEventList());
        return search;
    }

    @Override
    protected TableStateCentralArea<WebResourceUser> createCentralArea() {
        ColumnTableFormat format = new ColumnTableFormat(new ColumnFormat[]{new PropertyColumnFormat(WebResourceUser.Properties.GROUP), new PropertyColumnFormat(WebResourceUser.Properties.LABEL), new PropertyColumnFormat(WebResourceUser.Properties.LAST_ACCESSED), new PropertyColumnFormat(WebResourceUser.Properties.SYSTEM_STATE), new PropertyColumnFormat(WebResourceUser.Properties.USERNAME)});
        PersistentObjectTable<WebResourceUser> table = new PersistentObjectTable<WebResourceUser>(this.getObjectList(), format);
        return table;
    }

    @Override
    protected Class getDisplayingType() {
        return WebResourceUser.class;
    }
}

