/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.adyen;

import au.com.ordermate.xmlintegration.adyen.AdyenSurcharge;
import au.com.ordermate.xmlintegration.adyen.AdyenSurchargeConfiguration;
import au.com.ordermate.xmlintegration.adyen.AdyenTerminalSettingsMessage;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import officemate.adminkit.AddRemoveButtonPanel;
import officemate.components.AbstractObjectEditor;
import officemate.components.table.PersistentObjectTable;
import officemate.screens.setup.configuration.adyen.AdyenSurchargeTableFormat;
import ordermate.database.integration.adyen.AdyenIntegrationConfig;
import ordermate.database.users.AllPermissions;

public class AdyenSurchargeEditor
extends AbstractObjectEditor {
    private AdyenSurcharge surcharge;
    private EventList<AdyenSurchargeConfiguration> surchargeConfig;
    private PersistentObjectTable<AdyenSurchargeConfiguration> surchargeConfigTable;
    private AdyenTerminalSettingsMessage terminalSettings;

    public AdyenSurchargeEditor(AdyenSurcharge theSurcharge, AdyenTerminalSettingsMessage msg) {
        this.setLayout(new BorderLayout());
        this.surcharge = theSurcharge;
        this.surchargeConfig = new BasicEventList();
        this.surchargeConfig.addAll(Arrays.asList(this.surcharge.getConfigurations()));
        this.terminalSettings = msg;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AdyenSurchargeEditor.this.surchargeConfigTable = new PersistentObjectTable(AdyenSurchargeEditor.this.surchargeConfig, new AdyenSurchargeTableFormat(AdyenSurchargeEditor.this.surcharge));
                AdyenSurchargeEditor.this.surchargeConfigTable.setSize(AdyenSurchargeEditor.this.surchargeConfigTable.getTable().getSize());
                AdyenSurchargeEditor.this.surchargeConfigTable.setPreferredSize(AdyenSurchargeEditor.this.surchargeConfigTable.getTable().getSize());
                AdyenSurchargeEditor.this.add((Component)AdyenSurchargeEditor.this.surchargeConfigTable, "Center");
                JPanel buttonContainer = new JPanel(new BorderLayout());
                buttonContainer.add((Component)AdyenSurchargeEditor.this.setupButtonPanel(), "North");
                AdyenSurchargeEditor.this.add((Component)buttonContainer, "East");
            }
        });
    }

    private JPanel setupButtonPanel() {
        AddRemoveButtonPanel buttonPanel = new AddRemoveButtonPanel.AddRemovePanelBuilder().setAllowAdd(true).setAllowRemove(true).setAllowEdit(false).setCrudPermissions(AllPermissions.CONFIG_TERMINAL_MODES).build();
        buttonPanel.addAddActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AdyenSurchargeEditor.this.addObject();
            }
        });
        buttonPanel.addRemoveActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AdyenSurchargeEditor.this.removeObject();
            }
        });
        this.surchargeConfigTable.addSelectionDependentAction(buttonPanel.getRemoveAction());
        return buttonPanel;
    }

    public List<AdyenSurchargeConfiguration> getTerminalModes() {
        return new ArrayList<AdyenSurchargeConfiguration>((Collection<AdyenSurchargeConfiguration>)this.surchargeConfig);
    }

    private void addObject() {
        AdyenSurchargeConfiguration mode = new AdyenSurchargeConfiguration();
        mode.setCurrencyCode(AdyenIntegrationConfig.getInstance().getCurrencyCode().getLabel());
        this.surchargeConfig.add((Object)mode);
        this.surcharge.setConfigurations((AdyenSurchargeConfiguration[])this.surchargeConfig.toArray((Object[])new AdyenSurchargeConfiguration[0]));
        this.terminalSettings.setSurcharge(this.surcharge);
    }

    private void removeObject() {
        int result = JOptionPane.showConfirmDialog(new JFrame(), "Are you sure you wish to delete the selected Surcharge? \nThis operation cannot be undone.", "Delete supplier?", 0, 2);
        if (result == 0) {
            AdyenSurchargeConfiguration modeToDelete = this.surchargeConfigTable.getSelectedObject();
            this.surchargeConfig.remove((Object)modeToDelete);
            this.surcharge.setConfigurations((AdyenSurchargeConfiguration[])this.surchargeConfig.toArray((Object[])new AdyenSurchargeConfiguration[0]));
            this.terminalSettings.setSurcharge(this.surcharge);
        }
    }
}

