/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.adyen;

import au.com.ordermate.xmlintegration.adyen.AdyenSurcharge;
import au.com.ordermate.xmlintegration.adyen.AdyenSurchargeConfiguration;
import ca.odell.glazedlists.BasicEventList;
import java.math.BigDecimal;
import java.util.Arrays;
import officemate.components.table.SelectionColumnFormat;
import officemate.components.tableformat.AbstractEditableColumnFormat;
import officemate.components.tableformat.ColumnTableFormat;

public class AdyenSurchargeTableFormat
extends ColumnTableFormat {
    BasicEventList allSurcharges = new BasicEventList();

    public AdyenSurchargeTableFormat(AdyenSurcharge cfg) {
        this.allSurcharges.addAll(Arrays.asList(cfg.getConfigurations()));
        this.addColumns(Arrays.asList(new AbstractEditableColumnFormat("Brand", String.class){

            public Object resolveColumnValue(Object baseObject) {
                return ((AdyenSurchargeConfiguration)baseObject).getBrand();
            }

            @Override
            public Object setValue(Object baseObject, Object editedValue) {
                ((AdyenSurchargeConfiguration)baseObject).setBrand((String)editedValue);
                return baseObject;
            }
        }, new AbstractEditableColumnFormat("Amount", BigDecimal.class){

            public Object resolveColumnValue(Object baseObject) {
                return ((AdyenSurchargeConfiguration)baseObject).getCurrency().getAmount();
            }

            @Override
            public Object setValue(Object baseObject, Object editedValue) {
                ((AdyenSurchargeConfiguration)baseObject).setAmount((BigDecimal)editedValue);
                return baseObject;
            }
        }, new AbstractEditableColumnFormat("Percentage", BigDecimal.class){

            public Object resolveColumnValue(Object baseObject) {
                return ((AdyenSurchargeConfiguration)baseObject).getCurrency().getPercentage();
            }

            @Override
            public Object setValue(Object baseObject, Object editedValue) {
                ((AdyenSurchargeConfiguration)baseObject).setPercentage((BigDecimal)editedValue);
                return baseObject;
            }
        }, new SelectionColumnFormat<AdyenSurchargeConfiguration>("Credit"){

            @Override
            public Object resolveColumnValue(Object baseObject) {
                return ((AdyenSurchargeConfiguration)baseObject).usesCredit();
            }

            @Override
            public Object setValue(Object baseObject, Object editedValue) {
                if (((Boolean)editedValue).booleanValue()) {
                    ((AdyenSurchargeConfiguration)baseObject).addSource("Credit");
                } else {
                    ((AdyenSurchargeConfiguration)baseObject).removeSource("Credit");
                }
                return baseObject;
            }
        }, new SelectionColumnFormat<AdyenSurchargeConfiguration>("Debit"){

            @Override
            public Object resolveColumnValue(Object baseObject) {
                return ((AdyenSurchargeConfiguration)baseObject).usesDebit();
            }

            @Override
            public Object setValue(Object baseObject, Object editedValue) {
                if (((Boolean)editedValue).booleanValue()) {
                    ((AdyenSurchargeConfiguration)baseObject).addSource("Debit");
                } else {
                    ((AdyenSurchargeConfiguration)baseObject).removeSource("Debit");
                }
                return baseObject;
            }
        }));
    }
}

