/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.cards;

import au.com.ordermate.gui.ObjectEditor;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import javax.swing.JOptionPane;
import javax.swing.table.TableCellEditor;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.EditablePropertyColumnFormat;
import officemate.components.tableformat.renderers.AutoCompleteComboCellEditor;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.misc.CustomerCard;
import ordermate.database.sales.CustomerCardHelper;
import ordermate.database.users.Permission;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class CustomerCardState
extends AbstractEditableTableState<CustomerCard> {
    public CustomerCardState(Permission permission) {
        super("Customer Card", permission, "Register, activate and deactivate customer cards.");
    }

    @Override
    protected TableStateCentralArea<CustomerCard> createCentralArea() {
        ColumnTableFormat format = new ColumnTableFormat();
        format.addColumn((ColumnFormat)new PropertyColumnFormat(CustomerCard.Properties.CARD_ID));
        EventList states = GlazedLists.eventListOf((Object[])new SystemState[]{SystemState.ACTIVE_STATE, SystemState.INACTIVE_STATE});
        format.addColumn(new EditablePropertyColumnFormat("Active", CustomerCard.Properties.SYSTEM_STATE).setCustomEditor((TableCellEditor)((Object)new AutoCompleteComboCellEditor(states))));
        PersistentObjectTable<CustomerCard> cardTable = new PersistentObjectTable<CustomerCard>(this.getObjectList(), format);
        return cardTable;
    }

    @Override
    protected Class<CustomerCard> getDisplayingType() {
        return CustomerCard.class;
    }

    @Override
    protected ObjectEditor<CustomerCard> createObjectEditor() {
        return null;
    }

    @Override
    public String getTypeName() {
        return "Customer Card";
    }

    @Override
    protected CustomerCard createNewObject() {
        String input = JOptionPane.showInputDialog(this, (Object)"Please swipe the card now...");
        if (input == null || input.trim().isEmpty()) {
            return null;
        }
        CustomerCardHelper helper = new CustomerCardHelper();
        if (!helper.isValidCardId(input = input.trim())) {
            Dialogs.showWarningDialog("Invalid Customer Input", "'" + input + "' is not a valid card id.");
            return null;
        }
        CustomerCard card = helper.getCardByCardId(input);
        if (card != null) {
            Dialogs.showWarningDialog("Duplicate Card", "'" + input + "' is already registered.");
            return null;
        }
        return new CustomerCard(input);
    }
}

