/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.dayparts;

import au.com.ordermate.gui.ObjectEditedDespatch;
import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.util.DateTimeUtils;
import ca.odell.glazedlists.EventList;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.screens.setup.configuration.dayparts.DayPartEditor;
import ordermate.database.misc.DayPart;
import ordermate.database.users.AllPermissions;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class DayPartState
extends AbstractEditableTableState<DayPart> {
    public DayPartState() {
        super("Day Parts", AllPermissions.DAY_PARTS, "Add, Edit and Delete reporting day parts");
    }

    @Override
    protected ObjectEditor<DayPart> createObjectEditor() {
        return new DayPartEditor();
    }

    @Override
    public String getTypeName() {
        return "Day Parts";
    }

    @Override
    protected void doDelete(List<DayPart> toDelete) {
        super.doDelete(toDelete);
        ObjectEditedDespatch.getInstance().fireObjectEdited(DayPart.class);
    }

    @Override
    public void gotObjectEdited(DayPart part) {
        super.gotObjectEdited(part);
        ObjectEditedDespatch.getInstance().fireObjectEdited(DayPart.class);
    }

    @Override
    protected TableStateCentralArea<DayPart> createCentralArea() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm");
        ColumnTableFormat format = new ColumnTableFormat(new ColumnFormat[]{new PropertyColumnFormat(DayPart.Properties.LABEL), new PropertyColumnFormat(DayPart.Properties.START_TIME, (Format)dateFormat)});
        PersistentObjectTable<DayPart> table = new PersistentObjectTable<DayPart>(this.getObjectList(), format);
        return table;
    }

    @Override
    protected Class<DayPart> getDisplayingType() {
        return DayPart.class;
    }

    @Override
    protected DayPart createNewObject() {
        Date startDate;
        DayPart newPart = (DayPart)super.createNewObject();
        DayPart lastPart = null;
        EventList partList = this.getObjectList();
        if (partList.size() > 0) {
            lastPart = (DayPart)partList.get(0);
            for (DayPart part : partList) {
                if (!part.getStartTime().after(lastPart.getStartTime())) continue;
                lastPart = part;
            }
        }
        Calendar cal = Calendar.getInstance();
        if (lastPart != null) {
            cal.setTime(lastPart.getStartTime());
            cal.add(11, 1);
            startDate = cal.getTime();
        } else {
            cal.set(11, 0);
            cal.set(12, 0);
            startDate = cal.getTime();
        }
        startDate = DateTimeUtils.cleanDatePart((Date)startDate);
        newPart.setStartTime(startDate);
        return newPart;
    }
}

