/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.deliveryzones;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import ca.odell.glazedlists.swing.EventComboBoxModel;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import officemate.components.AbstractObjectEditor;
import officemate.screens.setup.configuration.deliveryzones.DeliveryZoneComparator;
import ordermate.OrderMate;
import ordermate.database.delivery.DeliveryZone;
import ordermate.database.delivery.StreetDirectoryReference;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.binding.validators.NotEmptyValidator;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.Validator;

public class StreetDirectoryReferenceEditor
extends AbstractObjectEditor<StreetDirectoryReference> {
    private JTextField streetName = new JTextField(30);
    private JComboBox streetType;
    private JComboBox suburb;
    private JComboBox postCode;
    private JComboBox pageNumber;
    private JComboBox gridPosition;
    private JComboBox deliveryZone;
    private Set<String> allStreetTypes;
    private Set<String> allSuburbs;
    private Set<String> allPostCodes;
    private Set<String> allPageNumbers;
    private Set<String> allGridPositions;
    private List<DeliveryZone> allZones;

    public StreetDirectoryReferenceEditor() {
        Binding streetNameBinding = this.getBindings().createBinding(StreetDirectoryReference.Properties.STREET_NAME, (Object)this.streetName, "text");
        streetNameBinding.setValidator((Validator)new NotEmptyValidator());
        FieldPanelBuilder builder = new FieldPanelBuilder();
        builder.addRow("Street Name ", (Component)this.streetName);
        this.streetName.setName("streetName");
        this.streetType = this.setupComboBox(StreetDirectoryReference.Properties.STREET_TYPE, (ComboBoxModel)new EventComboBoxModel(GlazedLists.eventList(this.allStreetTypes)), (Validator)new NotEmptyValidator());
        builder.addRow("Street Type", (Component)this.streetType);
        this.streetType.setName("streetType");
        this.suburb = this.setupComboBox(StreetDirectoryReference.Properties.SUBURB, (ComboBoxModel)new EventComboBoxModel(GlazedLists.eventList(this.allSuburbs)), (Validator)new NotEmptyValidator());
        builder.addRow("Suburb", (Component)this.suburb);
        this.suburb.setName("suburb");
        this.postCode = this.setupComboBox(StreetDirectoryReference.Properties.POSTCODE, (ComboBoxModel)new EventComboBoxModel(GlazedLists.eventList(this.allPostCodes)), (Validator)new NotEmptyValidator());
        builder.addRow("Post Code", (Component)this.postCode);
        this.postCode.setName("postCode");
        this.pageNumber = this.setupComboBox(StreetDirectoryReference.Properties.PAGE, (ComboBoxModel)new EventComboBoxModel(GlazedLists.eventList(this.allPageNumbers)), (Validator)new NotEmptyValidator());
        builder.addRow("Page ", (Component)this.pageNumber);
        this.pageNumber.setName("pageNumber");
        this.gridPosition = this.setupComboBox(StreetDirectoryReference.Properties.GRID_POSITION, (ComboBoxModel)new EventComboBoxModel(GlazedLists.eventList(this.allGridPositions)), (Validator)new NotEmptyValidator());
        builder.addRow("Grid Position", (Component)this.gridPosition);
        this.gridPosition.setName("gridPosition");
        this.deliveryZone = this.setupComboBox(StreetDirectoryReference.Properties.ZONE, (ComboBoxModel)new EventComboBoxModel(GlazedLists.eventList((Collection)DeliveryZone.findAll())), (Validator)new NotEmptyValidator());
        builder.addRow("Delivery Zone ", (Component)this.deliveryZone);
        this.deliveryZone.setName("deliveryZone");
        this.add(builder.getPanel());
        this.populateLists();
    }

    private void populateLists() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                StreetDirectoryReferenceEditor.this.allStreetTypes = new TreeSet();
                StreetDirectoryReferenceEditor.this.allSuburbs = new TreeSet();
                StreetDirectoryReferenceEditor.this.allPostCodes = new TreeSet();
                StreetDirectoryReferenceEditor.this.allPageNumbers = new TreeSet();
                StreetDirectoryReferenceEditor.this.allGridPositions = new TreeSet();
                TreeSet<DeliveryZone> allZones = new TreeSet<DeliveryZone>(new DeliveryZoneComparator());
                allZones.addAll(DeliveryZone.findAll());
                List allEntries = StreetDirectoryReference.getAllEntries();
                for (StreetDirectoryReference ref : allEntries) {
                    StreetDirectoryReferenceEditor.this.allStreetTypes.add(ref.getStreetType());
                    StreetDirectoryReferenceEditor.this.allSuburbs.add(ref.getSuburb());
                    StreetDirectoryReferenceEditor.this.allPostCodes.add(ref.getPostcode());
                    if (ref.getPage() != null) {
                        StreetDirectoryReferenceEditor.this.allPageNumbers.add(ref.getPage());
                    }
                    if (ref.getGridPosition() == null) continue;
                    StreetDirectoryReferenceEditor.this.allGridPositions.add(ref.getGridPosition());
                }
                StreetDirectoryReferenceEditor.this.addAutoCompleteSupport(StreetDirectoryReferenceEditor.this.allStreetTypes, StreetDirectoryReferenceEditor.this.streetType);
                StreetDirectoryReferenceEditor.this.addAutoCompleteSupport(StreetDirectoryReferenceEditor.this.allSuburbs, StreetDirectoryReferenceEditor.this.suburb);
                StreetDirectoryReferenceEditor.this.addAutoCompleteSupport(StreetDirectoryReferenceEditor.this.allPostCodes, StreetDirectoryReferenceEditor.this.postCode);
                StreetDirectoryReferenceEditor.this.addAutoCompleteSupport(StreetDirectoryReferenceEditor.this.allPageNumbers, StreetDirectoryReferenceEditor.this.pageNumber);
                StreetDirectoryReferenceEditor.this.addAutoCompleteSupport(StreetDirectoryReferenceEditor.this.allGridPositions, StreetDirectoryReferenceEditor.this.gridPosition);
                StreetDirectoryReferenceEditor.this.deliveryZone.setModel(new EventComboBoxModel(GlazedLists.eventList(allZones)));
                StreetDirectoryReferenceEditor.this.streetType.setEditable(true);
                StreetDirectoryReferenceEditor.this.suburb.setEditable(true);
                StreetDirectoryReferenceEditor.this.postCode.setEditable(true);
                StreetDirectoryReferenceEditor.this.pageNumber.setEditable(true);
                StreetDirectoryReferenceEditor.this.gridPosition.setEditable(true);
                StreetDirectoryReferenceEditor.this.deliveryZone.setEditable(true);
            }
        };
        try {
            SwingUtilities.invokeLater(r);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            OrderMate.LOG.info(ex.getMessage(), (Throwable)ex);
        }
    }

    private void addAutoCompleteSupport(Set set, JComboBox comboBox) {
        EventList listFromSet = GlazedLists.eventList((Collection)set);
        comboBox.setModel(new EventComboBoxModel(listFromSet));
        AutoCompleteSupport.install((JComboBox)comboBox, (EventList)listFromSet);
    }
}

