/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.deliveryzones;

import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.searchfield.java.ComboSearchField;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import au.com.ordermate.search.searchfield.java.StringSearchField;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import java.util.ArrayList;
import java.util.TreeSet;
import javax.swing.Action;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.components.search.ObjectPropertySearch;
import officemate.screens.setup.configuration.deliveryzones.DeliveryZoneComparator;
import ordermate.database.delivery.DeliveryZone;
import ordermate.database.delivery.StreetDirectoryReference;
import ordermate.database.searchers.delivery.StreetDirectoryReferenceSearcher;

public class StreetDirectoryReferenceSearch
extends ObjectPropertySearch<StreetDirectoryReference> {
    private EventList<DeliveryZone> zones = new BasicEventList();
    private StreetDirectoryReferenceSearcher searcher = (StreetDirectoryReferenceSearcher)super.getPropertySearcher();

    public StreetDirectoryReferenceSearch() {
        super(StreetDirectoryReference.class);
        this.setSystemStateFilterActive(true);
        RefreshAction action = new RefreshAction((Refreshable)this);
        this.addSearchField((SearchGuiField)new StringSearchField("Suburb", this.searcher.getSuburbFilter(), (Action)action));
        this.addSearchField((SearchGuiField)new StringSearchField("Post Code", this.searcher.getPostCodeFilter(), (Action)action));
        this.addSearchField((SearchGuiField)new StringSearchField("Street", this.searcher.getStreetNameFilter(), (Action)action));
        this.addSearchField((SearchGuiField)new ComboSearchField("Zone", this.searcher.getZoneFilter(), true, (Action)action, this.zones));
    }

    @Override
    protected ObjectQuerySearcher<StreetDirectoryReference> constructPropertySearcher() {
        return new StreetDirectoryReferenceSearcher();
    }

    @Override
    public void reaquireSearchOptions() {
        TreeSet<DeliveryZone> allDeliveryZones = new TreeSet<DeliveryZone>(new DeliveryZoneComparator());
        allDeliveryZones.addAll(DeliveryZone.findAll());
        ArrayList<DeliveryZone> sortedList = new ArrayList<DeliveryZone>(allDeliveryZones);
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.zones, sortedList);
        super.reaquireSearchOptions();
    }

    public EventList getZones() {
        return this.zones;
    }
}

