/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.docket;

import au.com.ordermate.glazedlists.StringComparator;
import au.com.ordermate.gui.adminkit.ComponentUtils;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.propertyaccessor.PropertyAccessor;
import au.com.ordermate.persistence.propertyaccessor.PropertyAccessorVendor;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class PropertySelector
extends JPanel {
    public final Signal<?, ?, ?, ?, ?> propertyChanged = Signals.createSignal();
    private JComboBox classBox;
    private JComboBox propertyBox;
    private PropertyAccessorVendor vendor;
    private ActionListener listener;

    public PropertySelector(PropertyAccessorVendor yourVendor) {
        this.vendor = yourVendor;
        this.setupComponents();
    }

    private void setupComponents() {
        this.propertyBox = new JComboBox();
        this.propertyBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value != null) {
                    ((JLabel)comp).setText(((PropertiedObject.Property)value).getName());
                } else {
                    ((JLabel)comp).setText("<None>");
                }
                return comp;
            }
        });
        ComponentUtils.setupComboBox((JComboBox)this.propertyBox);
        List classes = this.vendor.getClasses();
        this.classBox = new JComboBox<Object>(classes.toArray());
        this.classBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value != null) {
                    ((JLabel)comp).setText(((Class)value).getSimpleName());
                } else {
                    ((JLabel)comp).setText("<None>");
                }
                return comp;
            }
        });
        this.classBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertySelector.this.populateProperties();
            }
        });
        ComponentUtils.setupComboBox((JComboBox)this.classBox);
        this.add(this.classBox);
        this.add(this.propertyBox);
    }

    private void populateProperties() {
        if (this.listener != null) {
            this.propertyBox.removeActionListener(this.listener);
        }
        this.propertyBox.removeAllItems();
        List props = this.vendor.getProperties((Class)this.classBox.getSelectedItem());
        Collections.sort(props, new StringComparator());
        this.propertyBox.addItem(null);
        for (PropertiedObject.Property property : props) {
            this.propertyBox.addItem(property);
        }
        if (this.listener == null) {
            this.listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PropertySelector.this.firePropertyChange("value", false, true);
                    PropertySelector.this.propertyChanged.emit();
                }
            };
        }
        this.propertyBox.addActionListener(this.listener);
    }

    public void setValue(String value) {
        PropertyAccessor accessor = this.vendor.fromString(value);
        if (accessor != null) {
            this.classBox.setSelectedItem(accessor.getProperty().getOwner());
            this.propertyBox.setSelectedItem(accessor.getProperty());
        }
    }

    public String getValue() {
        PropertiedObject.Property prop;
        if (this.propertyBox != null && (prop = (PropertiedObject.Property)this.propertyBox.getSelectedItem()) != null) {
            return this.vendor.toString((PropertyAccessor)prop);
        }
        return null;
    }
}

