/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.docketimage;

import au.com.ordermate.dockets.DocketImageFinder;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.Executable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.image.ImageHelper;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.EventComboBoxModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import officemate.components.AbstractObjectEditor;
import ordermate.database.misc.resource.DocketImage;
import ordermate.database.reports.general.StringReport;
import ordermate.gui.FieldPanelBuilder;
import ordermate.services.misc.CallMethodOnClassExecutable;

public class DocketImageEditor
extends AbstractObjectEditor<DocketImage>
implements ActionListener {
    private JButton importFile;
    private JLabel imageLabel;
    private JComboBox maxWidthCombo;
    private JCheckBox hiDPICheck;
    private RenderedImage theImage;
    private JComboBox groupCombo;

    public DocketImageEditor() {
        this.setupComponents();
    }

    private void setupComponents() {
        FieldPanelBuilder builder = new FieldPanelBuilder();
        this.groupCombo = this.setupComboBox(DocketImage.Properties.IMAGE_GROUP, GlazedLists.eventListOf((Object[])new String[]{"Logo", "Footer", "Divider"}));
        this.groupCombo.setEditable(true);
        builder.addRow("Group", (Component)this.groupCombo);
        builder.addRow("Label", (Component)this.setupTextField(DocketImage.Properties.LABEL, 20));
        builder.addRow("Sequence", (Component)this.setupIntSpinner(DocketImage.Properties.SEQUENCE, 1, 0, Integer.MAX_VALUE, 1, 4));
        this.hiDPICheck = this.setupCheckBox(DocketImage.Properties.HIGH_DPI);
        builder.addRow("High Def", (Component)this.hiDPICheck);
        this.hiDPICheck.setSelected(true);
        this.importFile = new JButton("Load Picture...");
        this.importFile.addActionListener(this);
        this.maxWidthCombo = new JComboBox<Object>(new Object[]{"512 (Epson)", "576 (Senor)"});
        this.maxWidthCombo.setEditable(true);
        builder.addRow("Printer Width", (Component)this.maxWidthCombo);
        builder.addRow("Image", (Component)this.importFile);
        this.add(builder.getPanel());
        this.imageLabel = new JLabel("No image");
        JScrollPane scrolly = new JScrollPane(this.imageLabel);
        scrolly.getViewport().setPreferredSize(new Dimension(680, 450));
        this.add(scrolly);
    }

    @Override
    public void setObject(DocketImage docko) {
        super.setObject(docko);
        this.theImage = docko.getImage().getImage();
        this.setImage();
        List reports = PersistenceManager.getObjectList(StringReport.class, (String)Query.select((PropertiedObject.Property)DocketImage.Properties.ID).selectFunc("image_group as 'value'").groupBy(DocketImage.Properties.IMAGE_GROUP).orderBy(DocketImage.Properties.IMAGE_GROUP).toString());
        EventList list = GlazedLists.eventListOf((Object[])new String[]{"Logo", "Footer", "Footer2", "Divider"});
        for (StringReport nextReport : reports) {
            list.remove((Object)nextReport.getValue());
            list.add((Object)nextReport.getValue());
        }
        this.groupCombo.setModel(new EventComboBoxModel(list));
        this.groupCombo.setSelectedItem(docko.getImageGroup());
    }

    private void setImage() {
        if (this.theImage != null) {
            this.imageLabel.setIcon(new ImageIcon((Image)((Object)this.theImage)));
            this.imageLabel.setText("Width " + this.theImage.getWidth() + " Height " + this.theImage.getHeight());
        } else {
            this.imageLabel.setText("No Image Loaded");
            this.imageLabel.setIcon(null);
        }
    }

    @Override
    public void saveObject() {
        super.saveObject();
        ((DocketImage)this.getObject()).getImage().setImage(new ImageHelper().fitImageTo((Image)((Object)this.theImage), this.theImage.getWidth(), this.theImage.getHeight()));
        CallMethodOnClassExecutable exec = new CallMethodOnClassExecutable(DocketImageFinder.class.getCanonicalName(), new String[]{"getInstance", "clearCache"});
        PersistenceManager.getServerConnection().runSync((Executable)exec);
    }

    private void importFile() {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new FileNameExtensionFilter("Image Files (jpg,  png)", "jpg", "png"));
        if (chooser.showOpenDialog(this) == 0) {
            try {
                this.theImage = ImageIO.read(chooser.getSelectedFile());
                this.modifyImage();
                this.setImage();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void modifyImage() {
        int width = 512;
        String maxString = String.valueOf(this.maxWidthCombo.getSelectedItem());
        if (maxString != null) {
            try {
                int index = maxString.indexOf(" ");
                if (index > 0) {
                    maxString = maxString.substring(0, index);
                }
                width = Integer.parseInt(maxString);
            }
            catch (Exception index) {
                // empty catch block
            }
        }
        if (!this.hiDPICheck.isSelected()) {
            width /= 2;
        }
        ImageHelper helper = new ImageHelper();
        if (this.theImage.getWidth() > width) {
            this.theImage = (RenderedImage)((Object)helper.fitImageTo((Image)((Object)this.theImage), width, Integer.MAX_VALUE));
        }
        this.theImage = helper.removeAlpha((Image)((Object)this.theImage), Color.WHITE);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.importFile) {
            this.importFile();
        }
    }
}

