/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.feedback;

import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.propertyaccessor.PropertyAccessor;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.swing.EventComboBoxModel;
import java.util.Collection;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.table.TableCellEditor;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.search.ObjectPropertySearch;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.EditablePropertyColumnFormat;
import officemate.components.tableformat.PopupSelectFileColumnFormat;
import ordermate.database.feedback.FeedbackAck;
import ordermate.database.feedback.FeedbackQuestion;
import ordermate.database.users.AllPermissions;
import ordermate.reports.table.ColumnFormat;
import org.jdesktop.swingx.autocomplete.ComboBoxCellEditor;

public class QuestionsState
extends AbstractEditableTableState<FeedbackQuestion> {
    private EventList<FeedbackAck> allAcks;
    private EventComboBoxModel<FeedbackAck> acksModel;
    private QuestionsSearcher searcher;

    public QuestionsState() {
        super("Questions", AllPermissions.GOD_ONLY, "Add and Remove possible questions.");
    }

    @Override
    protected OfficeMateObjectSearch<FeedbackQuestion> createSearchPanelFactory() {
        this.searcher = new QuestionsSearcher();
        ObjectPropertySearch<FeedbackQuestion> search = new ObjectPropertySearch<FeedbackQuestion>(FeedbackQuestion.class, (ObjectQuerySearcher<FeedbackQuestion>)this.searcher, (EventList<FeedbackQuestion>)new BasicEventList());
        return search;
    }

    @Override
    protected ObjectEditor<FeedbackQuestion> createObjectEditor() {
        return null;
    }

    @Override
    public String getTypeName() {
        return "Question";
    }

    @Override
    protected TableStateCentralArea<FeedbackQuestion> createCentralArea() {
        this.allAcks = new BasicEventList();
        this.acksModel = new EventComboBoxModel(this.allAcks);
        JComboBox<FeedbackAck> acksBox = new JComboBox<FeedbackAck>((ComboBoxModel<FeedbackAck>)this.acksModel);
        ColumnTableFormat format = new ColumnTableFormat(new ColumnFormat[]{new EditablePropertyColumnFormat(FeedbackQuestion.Properties.LABEL), new EditablePropertyColumnFormat(FeedbackQuestion.Properties.QUESTION_TEXT), new PopupSelectFileColumnFormat("Icon", (PropertyAccessor)FeedbackQuestion.Properties.ICON, "*.jpg, *.png", "jpg", "png"), new EditablePropertyColumnFormat(FeedbackQuestion.Properties.DEFAULT_ACK).setCustomEditor((TableCellEditor)new ComboBoxCellEditor(acksBox)), new EditablePropertyColumnFormat(FeedbackQuestion.Properties.PAY_AT_TABLE)});
        PersistentObjectTable<FeedbackQuestion> table = new PersistentObjectTable<FeedbackQuestion>(this.getObjectList(), format);
        table.objectEdited().connect((Object)this, "gotEdited");
        return table;
    }

    @Override
    public void onStart() {
        if (this.allAcks != null) {
            this.allAcks.clear();
            this.allAcks.addAll((Collection)PersistenceManager.getObjectList(FeedbackAck.class, (String)Query.select(FeedbackAck.class).active(FeedbackAck.class).toString()));
        }
        super.onStart();
    }

    @Override
    protected FeedbackQuestion createNewObject() {
        FeedbackQuestion question = new FeedbackQuestion();
        question.setLabel("New Question");
        question.setQuestionText("Insert Question Text...");
        return question;
    }

    @Override
    protected Class<FeedbackQuestion> getDisplayingType() {
        return FeedbackQuestion.class;
    }

    public void gotEdited() {
        FeedbackQuestion question = (FeedbackQuestion)this.getCentralArea().getSelectedObject();
        if (question.isPayAtTable() && question.getAnswers().size() > 5) {
            Dialogs.showWarningDialog("Too many questions", "A maximum of 5 questions is recommended for Pay At Table Feedback");
        }
    }

    class QuestionsSearcher
    extends PropertySearcher<FeedbackQuestion> {
        public QuestionsSearcher() {
            super(FeedbackQuestion.class);
        }

        public ObjectQuery getBaseQuery() {
            ObjectQuery query = Query.select(FeedbackQuestion.class).active(FeedbackQuestion.class);
            return query;
        }
    }
}

