/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.labour;

import au.com.ordermate.persistence.PropertiedObject;
import java.awt.Component;
import java.text.DateFormat;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import officemate.components.AbstractObjectEditor;
import officemate.screens.setup.configuration.webservice.WebserviceConfigSetupEditor;
import ordermate.database.integration.labour.LabourIntegration;
import ordermate.database.integration.webservice.WebserviceIntegrationConfig;
import ordermate.gui.FieldPanelBuilder;

class LabourIntegrationEditor
extends AbstractObjectEditor<LabourIntegration> {
    private JLabel lastPull;
    private JLabel lastResult;
    private WebserviceConfigSetupEditor webEditor;
    private JCheckBox active;
    private JTextField extID;
    private JTextField cronSchedule;

    LabourIntegrationEditor() {
    }

    @Override
    protected void init() {
        FieldPanelBuilder builder = new FieldPanelBuilder();
        this.active = this.setupCheckBox(LabourIntegration.Properties.ACTIVE);
        builder.addRow("Active?", (Component)this.active, "Checked if integration is turned on.");
        this.extID = this.setupTextField(LabourIntegration.Properties.EXT_ID, 20);
        builder.addRow("External ID", (Component)this.extID, "The External ID as specified by the third party integrator");
        this.cronSchedule = this.setupTextField(LabourIntegration.Properties.CRON_SCHEDULE, 20);
        builder.addRow("Cron", (Component)this.cronSchedule);
        this.lastPull = new JLabel();
        builder.addRow("Last Pull", (Component)this.lastPull);
        this.lastResult = new JLabel();
        builder.addRow("Last Result", (Component)this.lastResult);
        this.webEditor = new WebserviceConfigSetupEditor(builder, this.getListener(), this.getBindings(), (PropertiedObject.Property<WebserviceIntegrationConfig>)LabourIntegration.Properties.WEBSERVICE_CONFIG);
        this.add(builder.getPanel());
    }

    @Override
    public void setObject(LabourIntegration value) {
        super.setObject(value);
        this.lastPull.setText(value.getLastPull() == null ? "Never" : DateFormat.getDateInstance().format(value.getLastPull()));
        this.lastResult.setText(value.getLastResult());
        this.webEditor.setObject(value.getWebserviceConfig());
    }
}

