/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.labour;

import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.persistence.Executable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.image.IconLoader;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.AbstractObjectEditor;
import officemate.components.ObjectEditorState;
import officemate.components.strategy.SaveStrategy;
import officemate.components.strategy.SaveStrategyFactory;
import officemate.components.strategy.StrategySaveCancelListener;
import officemate.screens.setup.configuration.labour.DoLabourUpdateExec;
import officemate.screens.setup.configuration.labour.LabourIntegrationEditor;
import ordermate.database.integration.labour.LabourIntegration;
import ordermate.database.users.AllPermissions;

public class LabourIntegrationState
extends ObjectEditorState<LabourIntegration>
implements StrategySaveCancelListener {
    private SaveStrategy saveStrategy;

    public LabourIntegrationState() {
        super("Labour Integration", AllPermissions.CONFIG_INTEGRATIONS, "Setup your Third Party Labour Integration");
        this.addAction(new UpdateNowAction());
        this.saveStrategy = SaveStrategyFactory.getDeferredSaveStrategy((Refreshable)this);
        this.saveStrategy.addSaveCancelListener(this);
        this.setSaveStrategy(this.saveStrategy);
    }

    @Override
    protected LabourIntegration acquireObject() {
        return LabourIntegration.getInstance();
    }

    @Override
    protected AbstractObjectEditor<LabourIntegration> createObjectEditor() {
        return new LabourIntegrationEditor();
    }

    @Override
    public void preSave() {
        this.getObjectEditor().saveObject();
    }

    @Override
    public void preCancel() {
        this.getObjectEditor().revertObject();
    }

    @Override
    public void postSave() {
    }

    @Override
    protected void setObjectToEdit(LabourIntegration obj) {
        super.setObjectToEdit(obj);
        this.saveStrategy.clear();
    }

    @Override
    protected void onEnd() {
        if (this.saveStrategy.isChanged()) {
            this.saveStrategy.promptForSave(this.getScreenPanel());
        }
        super.onEnd();
    }

    class UpdateNowAction
    extends AbstractAction {
        UpdateNowAction() {
            super("Update Now", IconLoader.get((String)"/officemate/images/resync.png"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DoLabourUpdateExec update = new DoLabourUpdateExec();
            String output = (String)PersistenceManager.getServerConnection().runSync((Executable)update);
            Dialogs.showMessageDialog("Labour Integration Results", "Result: " + (output == null ? "None" : output));
            LabourIntegrationState.this.refresh();
        }
    }
}

