/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.locations;

import au.com.ordermate.gui.ObjectEditor;
import ca.odell.glazedlists.EventList;
import java.util.List;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.EditablePropertyColumnFormat;
import ordermate.database.hardware.TerminalLocation;
import ordermate.database.users.AllPermissions;
import ordermate.reports.table.ColumnFormat;

public class LocationsState
extends AbstractEditableTableState<TerminalLocation> {
    public static final String MSG_CANNOT_DELETE_TERMINAL_LOCATION = "You must have at least one Terminal Location!";

    public LocationsState() {
        super("Terminal Locations", AllPermissions.LOCATIONS, "View, add and configure Terminal Locations.");
    }

    @Override
    protected ObjectEditor<TerminalLocation> createObjectEditor() {
        return null;
    }

    @Override
    public String getTypeName() {
        return "Terminal Location";
    }

    @Override
    protected TableStateCentralArea<TerminalLocation> createCentralArea() {
        PersistentObjectTable<TerminalLocation> table = new PersistentObjectTable<TerminalLocation>(this.getObjectList(), new ColumnTableFormat(new ColumnFormat[]{new EditablePropertyColumnFormat("Name", TerminalLocation.Properties.LABEL)}));
        return table;
    }

    @Override
    protected Class<TerminalLocation> getDisplayingType() {
        return TerminalLocation.class;
    }

    @Override
    public EventList<TerminalLocation> getObjectList() {
        this.setFilterActive(true);
        return super.getObjectList();
    }

    @Override
    public void gotObjectEdited(TerminalLocation editedObject) {
        super.gotObjectEdited(editedObject);
        this.refresh();
    }

    @Override
    protected boolean isDeleteAllowed(List<TerminalLocation> toDelete) {
        List currentActiveTerminalLocations = TerminalLocation.getTerminalLocations();
        if (currentActiveTerminalLocations.size() <= toDelete.size()) {
            String title = "Cannot Delete Terminal Location";
            Dialogs.showErrorDialog("Cannot Delete Terminal Location", MSG_CANNOT_DELETE_TERMINAL_LOCATION);
            return false;
        }
        return super.isDeleteAllowed(toDelete);
    }
}

