/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.onlineintegration;

import au.com.ordermate.gui.renderer.StringifierListCellRenderer;
import au.com.ordermate.util.Stringifier;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.swing.EventComboBoxModel;
import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JSpinner;
import officemate.components.AbstractObjectEditor;
import officemate.screens.setup.configuration.onlineintegration.AccountTypeETAStringifier;
import ordermate.database.integration.online.EtaMode;
import ordermate.database.integration.online.OnlineIntegrationETA;
import ordermate.database.sales.AccountType;
import ordermate.gui.FieldPanelBuilder;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.Binding;

public class OnlineIntegrationETAEditor
extends AbstractObjectEditor<OnlineIntegrationETA> {
    private EventList<AccountType> accountTypes = new BasicEventList();
    private JComboBox accountTypeSelection;
    private Binding accountTypeBinding;

    public OnlineIntegrationETAEditor() {
        this.getBindings().setStrategy(AutoBinding.UpdateStrategy.READ_WRITE);
        FieldPanelBuilder builder = new FieldPanelBuilder();
        this.accountTypeSelection = this.setupComboBox(OnlineIntegrationETA.Properties.ACCOUNT_TYPE, this.accountTypes);
        this.accountTypeSelection.setRenderer(new StringifierListCellRenderer((Stringifier)new AccountTypeETAStringifier()));
        this.accountTypeSelection.setPrototypeDisplayValue(AccountType.refundType);
        builder.addRow("Account Type: ", (Component)this.accountTypeSelection);
        for (Binding binding : this.getBindings().getAllBindings()) {
            if (!binding.getSourceProperty().toString().contains("accountType")) continue;
            this.accountTypeBinding = binding;
        }
        this.setBindAccountType(false);
        JSpinner defaultETASpinner = this.setupIntSpinner(OnlineIntegrationETA.Properties.DEFAULT_ETA, 5, 5, null, 30, 4);
        builder.addRow("Default ETA: ", (Component)defaultETASpinner);
        JSpinner currentETASpinner = this.setupIntSpinner(OnlineIntegrationETA.Properties.CURRENT_ETA, 5, 5, null, 30, 4);
        builder.addRow("Current ETA: ", (Component)currentETASpinner);
        BasicEventList etaModes = new BasicEventList();
        etaModes.addAll(EtaMode.register.values());
        JComboBox etaModeSelection = this.setupComboBox(OnlineIntegrationETA.Properties.ETA_MODE, etaModes);
        etaModeSelection.setRenderer(new StringifierListCellRenderer((Stringifier)new Stringifier<EtaMode>(){

            public String stringify(EtaMode object) {
                return object.getLabel();
            }
        }));
        builder.addRow("ETA Mode: ", (Component)etaModeSelection);
        this.add(builder.getPanel());
    }

    @Override
    public void setObject(OnlineIntegrationETA toEdit) {
        boolean canEditAccountType = !toEdit.isGlobalConfig();
        this.setBindAccountType(false);
        this.accountTypes.clear();
        if (toEdit.isGlobalConfig()) {
            this.accountTypes.add((Object)AccountType.allType);
        } else {
            this.accountTypes.addAll(AccountType.register.values());
            for (OnlineIntegrationETA eta : OnlineIntegrationETA.getAllETAs()) {
                if (eta.getAccountType().equals((Object)toEdit.getAccountType())) continue;
                this.accountTypes.remove((Object)eta.getAccountType());
            }
        }
        this.accountTypeSelection.setModel(new EventComboBoxModel(this.accountTypes));
        this.accountTypeSelection.setSelectedItem(toEdit.getAccountType());
        this.accountTypeSelection.setEnabled(canEditAccountType);
        this.setBindAccountType(canEditAccountType);
        super.setObject(toEdit);
    }

    private void setBindAccountType(boolean toBindOrNotToBind) {
        if (toBindOrNotToBind && !this.getBindings().getAllBindings().contains(this.accountTypeBinding)) {
            this.accountTypeBinding.bind();
            this.getBindings().addBinding(this.accountTypeBinding);
        } else if (!toBindOrNotToBind && this.getBindings().getAllBindings().contains(this.accountTypeBinding)) {
            this.getBindings().removeBinding(OnlineIntegrationETA.Properties.ACCOUNT_TYPE, this.accountTypeBinding);
        }
    }
}

