/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.onlineintegration;

import au.com.ordermate.gui.ObjectEditor;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.List;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.screens.setup.configuration.onlineintegration.OnlineIntegrationETAEditor;
import ordermate.database.integration.online.EtaMode;
import ordermate.database.integration.online.OnlineIntegrationETA;
import ordermate.database.sales.AccountType;
import ordermate.database.users.AllPermissions;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class OnlineIntegrationETASetupState
extends AbstractEditableTableState<OnlineIntegrationETA>
implements ListSelectionListener {
    public OnlineIntegrationETASetupState() {
        super("ETA Setup", AllPermissions.CONFIG_INTEGRATIONS, "Set up ETAs for online orders per account type");
        this.addSelectionChangeListener(this);
    }

    @Override
    public String getTypeName() {
        return "Online Order ETA";
    }

    @Override
    protected ObjectEditor<OnlineIntegrationETA> createObjectEditor() {
        return new OnlineIntegrationETAEditor();
    }

    @Override
    protected OnlineIntegrationETA createNewObject() {
        AccountType accountType = AccountType.allType;
        for (AccountType type : AccountType.register.values()) {
            if (!AccountType.allType.equals((Object)OnlineIntegrationETA.getETAForAccountType((AccountType)type).getAccountType())) continue;
            accountType = type;
            break;
        }
        if (!AccountType.allType.equals((Object)accountType)) {
            return new OnlineIntegrationETA(accountType, 30, 30, EtaMode.ALWAYS_ASK);
        }
        Dialogs.showInfoDialog("Cannot Create New ETA", "There is already an ETA for all Account Types. Please edit an existing ETA for the Account Type you wish to change.");
        return null;
    }

    @Override
    protected TableStateCentralArea<OnlineIntegrationETA> createCentralArea() {
        ColumnTableFormat format = new ColumnTableFormat(new ColumnFormat[]{new PropertyColumnFormat(OnlineIntegrationETA.Properties.ACCOUNT_TYPE, (Format)new AccountTypeFormat()), new PropertyColumnFormat(OnlineIntegrationETA.Properties.DEFAULT_ETA), new PropertyColumnFormat(OnlineIntegrationETA.Properties.CURRENT_ETA), new PropertyColumnFormat(OnlineIntegrationETA.Properties.ETA_MODE, (Format)new ETAModeFormat())});
        PersistentObjectTable<OnlineIntegrationETA> table = new PersistentObjectTable<OnlineIntegrationETA>(this.getObjectList(), format);
        return table;
    }

    @Override
    protected Class<OnlineIntegrationETA> getDisplayingType() {
        return OnlineIntegrationETA.class;
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        boolean defaultSelected = false;
        List selections = this.getCentralArea().getAllSelectedObjects();
        for (OnlineIntegrationETA eta : selections) {
            if (!eta.isGlobalConfig()) continue;
            defaultSelected = true;
        }
        this.getDeleteAction().setEnabled(!defaultSelected && selections.size() > 0);
    }

    class AccountTypeFormat
    extends Format {
        AccountTypeFormat() {
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            AccountType type = (AccountType)obj;
            if (AccountType.allType.equals((Object)type)) {
                toAppendTo.append("Global");
            } else {
                toAppendTo.append(type.getLabel());
            }
            return toAppendTo;
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            return null;
        }
    }

    class ETAModeFormat
    extends Format {
        ETAModeFormat() {
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            toAppendTo.append(((EtaMode)obj).getLabel());
            return toAppendTo;
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            return null;
        }
    }
}

