/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.onlineintegration;

import au.com.ordermate.gui.renderer.StringifierListCellRenderer;
import au.com.ordermate.util.StringUtils;
import au.com.ordermate.util.Stringifier;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.AbstractObjectEditor;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.integration.online.OnlineAccountSource;
import ordermate.database.integration.online.OnlineIntegrationConfig;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.queries.finance.debtors.DebtorQueries;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.binding.validators.FileExistsValidator;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.Validator;

public class OnlineIntegrationObjectEditor
extends AbstractObjectEditor<OnlineIntegrationConfig> {
    private final EventList<InventoryProfile> profiles = GlazedLists.eventList((Collection)InventoryProfile.getAllProfiles());
    private final EventList<FinanceUnit> financeUnits;
    private final EventList<AbstractDebtor> debtors = GlazedLists.eventList((Collection)DebtorQueries.getAllDebtors());
    private final EventList<CashDrawer> cashdrawers = GlazedLists.eventList((Collection)CashDrawer.getAllCashDrawers());
    private int currentConnectionTimeout = OnlineIntegrationConfig.getDefaultInstance().getPaypalConnectionTimeout();
    private int currentReadTimeout = OnlineIntegrationConfig.getDefaultInstance().getPaypalReadTimeout();
    private final JLabel lastMenuImportTime;
    private final JLabel lastOrderTime;
    private JComboBox paymentMethodCombo;
    private JComboBox financeUnitCombo;
    private JComboBox debtorCombo;
    private JComboBox cashdrawerCombo;

    OnlineIntegrationObjectEditor() {
        this.getBindings().setStrategy(AutoBinding.UpdateStrategy.READ_WRITE);
        FieldPanelBuilder builder = new FieldPanelBuilder();
        BasicEventList labels = new BasicEventList();
        labels.add((Object)"Default");
        for (OnlineAccountSource src : OnlineAccountSource.values()) {
            labels.add((Object)src.getSourceName());
        }
        JComboBox label = this.setupComboBox(OnlineIntegrationConfig.Properties.LABEL, labels);
        label.setEditable(true);
        builder.addRow("Label", (Component)label);
        builder.addRow("Import Required Warning", (Component)this.setupCheckBox(OnlineIntegrationConfig.Properties.IMPORT_REQUIRED_WARNING));
        JTextField field = this.setupTextField(OnlineIntegrationConfig.Properties.FILE_WATCHER_PATH, 50, (Validator)new FileExistsValidator(true, false).setAllowEmpty(true));
        builder.addRow("Import file path", (Component)field);
        JComboBox profilesGui = this.setupComboBox(OnlineIntegrationConfig.Properties.INVENTORY_PROFILE, this.profiles);
        builder.addRow("Menu Profile", (Component)profilesGui);
        this.paymentMethodCombo = this.setupComboBox(OnlineIntegrationConfig.Properties.PRE_PAYMENT_METHOD, GlazedLists.eventList(Arrays.asList(OnlineIntegrationConfig.PrePaymentMethod.values())));
        this.paymentMethodCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OnlineIntegrationObjectEditor.this.enablePaymentType();
            }
        });
        builder.addRow("Prepayment Method", (Component)this.paymentMethodCombo);
        this.debtorCombo = this.setupComboBox(OnlineIntegrationConfig.Properties.PAY_OFF_DEBTOR, this.debtors);
        builder.addRow("Pay To", (Component)this.debtorCombo);
        this.cashdrawerCombo = this.setupNullableComboBox(OnlineIntegrationConfig.Properties.CASH_DRAWER, this.cashdrawers, "<Default Online>");
        builder.addRow("Cash Drawer", (Component)this.cashdrawerCombo);
        this.financeUnits = new BasicEventList();
        this.financeUnitCombo = this.setupNullableComboBox(OnlineIntegrationConfig.Properties.PAY_OFF_FINANCE_UNIT, this.financeUnits, "<Default>");
        builder.addRow("Pay With", (Component)this.financeUnitCombo);
        builder.addRow("Play Sound", (Component)this.setupCheckBox(OnlineIntegrationConfig.Properties.PLAY_SOUND));
        JComboBox printingStrat = this.setupComboBox(OnlineIntegrationConfig.Properties.PRINTING_STRATEGY, GlazedLists.eventListOf((Object[])OnlineIntegrationConfig.PrintingStrategy.values()));
        printingStrat.setRenderer(new StringifierListCellRenderer((Stringifier)new Stringifier<OnlineIntegrationConfig.PrintingStrategy>(){

            public String stringify(OnlineIntegrationConfig.PrintingStrategy object) {
                return object.getLabel();
            }
        }));
        builder.addRow("Printing Strategy", (Component)printingStrat);
        JSpinner connectionTimeout = this.setupIntSpinner(OnlineIntegrationConfig.Properties.PAYPAL_CONNECTION_TIMEOUT, 1, 5000, 30000, this.currentConnectionTimeout, 15);
        connectionTimeout.setToolTipText("The length of time in which WaiterMate will wait for a connection to be made to the web payment provider. If you do not know what this does, leave as default (7500).");
        builder.addRow("Web Payment Connection Timeout (ms)", (Component)connectionTimeout);
        JSpinner readTimeout = this.setupIntSpinner(OnlineIntegrationConfig.Properties.PAYPAL_READ_TIMEOUT, 1, 5000, 30000, this.currentReadTimeout, 15);
        readTimeout.setToolTipText("The length of time in which WaiterMate will wait for a response to be read from the web payment provider. If you do not know what this does, leave as default (15000).");
        builder.addRow("Web Payment Read Timeout (ms)", (Component)readTimeout);
        this.addOnlineMenuExportVers(builder);
        this.lastMenuImportTime = new JLabel();
        builder.addRow("Last Menu Import Time", (Component)this.lastMenuImportTime);
        this.lastOrderTime = new JLabel();
        builder.addRow("Last Order Time", (Component)this.lastOrderTime);
        this.add(builder.getPanel());
    }

    private void addOnlineMenuExportVers(FieldPanelBuilder builder) {
        JComboBox menuVersCombo = this.setupComboBox(OnlineIntegrationConfig.Properties.MENU_COMPLIANCE_VERSION, GlazedLists.eventList(Arrays.asList(OnlineIntegrationConfig.MenuComplianceVersion.values())));
        DefaultListCellRenderer comboRenderer = new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value == OnlineIntegrationConfig.MenuComplianceVersion.Vers1_2) {
                    this.setToolTipText(OnlineIntegrationConfig.MenuComplianceVersion.Vers1_2.getDescription());
                } else {
                    this.setToolTipText(OnlineIntegrationConfig.MenuComplianceVersion.Vers1_1.getDescription());
                }
                return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
        };
        menuVersCombo.setRenderer(comboRenderer);
        builder.addRow("Online Menu Compliance Version", (Component)menuVersCombo);
    }

    @Override
    public void setObject(OnlineIntegrationConfig onlineIntegrationConfig) {
        super.setObject(onlineIntegrationConfig);
        this.lastMenuImportTime.setText(onlineIntegrationConfig.getLastMenuImportTime() != null ? DateFormat.getDateTimeInstance().format(onlineIntegrationConfig.getLastMenuImportTime()) : "None");
        this.lastOrderTime.setText(onlineIntegrationConfig.getLastOrderTime() != null ? DateFormat.getDateTimeInstance().format(onlineIntegrationConfig.getLastOrderTime()) : "None");
        this.enablePaymentType();
    }

    private void enablePaymentType() {
        OnlineIntegrationConfig.PrePaymentMethod method = (OnlineIntegrationConfig.PrePaymentMethod)this.paymentMethodCombo.getSelectedItem();
        if (OnlineIntegrationConfig.PrePaymentMethod.AUTO_PAY_TO_DEBTOR.equals((Object)method)) {
            this.debtorCombo.setEnabled(true);
            this.financeUnitCombo.setEnabled(false);
        } else {
            this.debtorCombo.setEnabled(false);
            this.financeUnitCombo.setEnabled(true);
        }
    }

    @Override
    public void refresh() {
        this.financeUnits.getReadWriteLock().writeLock().lock();
        this.financeUnits.clear();
        this.financeUnits.add(null);
        this.financeUnits.addAll((Collection)FinanceUnit.getWebUnits());
        this.financeUnits.addAll((Collection)FinanceUnit.getElectronicUnits());
        this.financeUnits.add((Object)FinanceUnit.getUnitForName((String)"Cash"));
        FinanceUnit hhUnit = FinanceUnit.getUnitForNameIgnoreSystemState((String)"HungryHungry");
        if (hhUnit != null) {
            this.financeUnits.remove((Object)hhUnit);
            this.financeUnits.add(1, (Object)hhUnit);
        }
        this.financeUnits.getReadWriteLock().writeLock().unlock();
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.profiles, InventoryProfile.getAllProfiles());
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.debtors, DebtorQueries.getAllDebtors());
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.cashdrawers, CashDrawer.getAllCashDrawers());
        this.currentConnectionTimeout = OnlineIntegrationConfig.getDefaultInstance().getPaypalConnectionTimeout();
        this.currentReadTimeout = OnlineIntegrationConfig.getDefaultInstance().getPaypalReadTimeout();
    }

    @Override
    public void saveObject() {
        OnlineIntegrationConfig.PrePaymentMethod selectedPaymentMethod = (OnlineIntegrationConfig.PrePaymentMethod)this.paymentMethodCombo.getSelectedItem();
        String warning = null;
        if (OnlineIntegrationConfig.PrePaymentMethod.AUTO_PAY_TO_DEBTOR == selectedPaymentMethod) {
            warning = OnlineIntegrationConfig.validateInactiveIPDebtor();
        }
        if (!StringUtils.isEmpty((String)warning)) {
            Dialogs.showMessageDialog("Warning", warning);
        }
        this.getBindings().saveObject();
    }
}

