/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.onlineintegration;

import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.DateRangeSearchFilter;
import au.com.ordermate.search.SearchFilterI;
import au.com.ordermate.search.searchfield.java.DateRangeSearchField;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import au.com.ordermate.util.DateTimeUtils;
import ca.odell.glazedlists.BasicEventList;
import java.text.Format;
import java.util.Date;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.search.ObjectPropertySearch;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.screens.setup.configuration.onlineintegration.WebResourceLogEditor;
import ordermate.database.misc.WebResourceLog;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class WebResourceLogState
extends AbstractEditableTableState<WebResourceLog> {
    @Override
    protected ObjectEditor<WebResourceLog> createObjectEditor() {
        return new WebResourceLogEditor();
    }

    @Override
    public String getTypeName() {
        return "Web Requests";
    }

    @Override
    protected TableStateCentralArea<WebResourceLog> createCentralArea() {
        ColumnTableFormat format = new ColumnTableFormat(new ColumnFormat[]{new PropertyColumnFormat(WebResourceLog.Properties.CREATION_DATE), new PropertyColumnFormat(WebResourceLog.Properties.CREATION_TIME, (Format)DateTimeUtils.getSQLTimeFormat()), new PropertyColumnFormat(WebResourceLog.Properties.HTTP_METHOD), new PropertyColumnFormat(WebResourceLog.Properties.QUERY_STRING), new PropertyColumnFormat(WebResourceLog.Properties.REMOTE_HOST), new PropertyColumnFormat(WebResourceLog.Properties.REMOTE_ADDRESS)});
        PersistentObjectTable<WebResourceLog> table = new PersistentObjectTable<WebResourceLog>(this.getObjectList(), format);
        return table;
    }

    @Override
    protected Class<WebResourceLog> getDisplayingType() {
        return WebResourceLog.class;
    }

    @Override
    protected OfficeMateObjectSearch<WebResourceLog> createSearchPanelFactory() {
        return new WebResourceLogSearch();
    }

    class WebResourceLogSearcher
    extends PropertySearcher<WebResourceLog> {
        private final DateRangeSearchFilter dateFilter;

        public WebResourceLogSearcher() {
            super(WebResourceLog.class);
            this.dateFilter = new DateRangeSearchFilter(WebResourceLog.Properties.CREATION_DATE, SQLDateType.DATE);
            this.addSearchFilter((SearchFilterI)this.dateFilter);
        }

        public DateRangeSearchFilter getDateRangeFilter() {
            return this.dateFilter;
        }

        protected ObjectQuery getBaseQuery() {
            return Query.select(WebResourceLog.class);
        }
    }

    class WebResourceLogSearch
    extends ObjectPropertySearch<WebResourceLog> {
        public WebResourceLogSearch() {
            super(WebResourceLog.class, new WebResourceLogSearcher(), new BasicEventList());
            DateRangeSearchField dateSearch = new DateRangeSearchField("Date Range", (IRangedQuerySearchFilter)((WebResourceLogSearcher)this.getPropertySearcher()).getDateRangeFilter(), new Date(), WebResourceLogState.this.getRefreshAction());
            dateSearch.useFixedDates();
            this.addSearchField((SearchGuiField)dateSearch);
        }
    }
}

