/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.printing;

import au.com.ordermate.gui.adminkit.ComponentUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.EditorKit;
import officemate.OfficeMate;
import officemate.components.renderers.DisplayableListCellRenderer;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.hardware.physical.PhysicalPrintDeviceType;
import ordermate.database.sales.AccountType;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class DocketTemplateLinesViewer
extends JPanel {
    public Signal<String, ?, ?, ?, ?> nameSelected = Signals.createSignal(String.class, (String)"name");
    public Signal<String, ?, ?, ?, ?> alignChanged = Signals.createSignal(String.class, (String)"align");
    public Signal<String, ?, ?, ?, ?> colorChanged = Signals.createSignal(String.class, (String)"color");
    public Signal<String, ?, ?, ?, ?> visibleChanged = Signals.createSignal(String.class, (String)"visible");
    public Signal<String, ?, ?, ?, ?> weightChanged = Signals.createSignal(String.class, (String)"weight");
    public Signal<String, ?, ?, ?, ?> underlineChanged = Signals.createSignal(String.class, (String)"underline");
    public Signal<Boolean, ?, ?, ?, ?> invertedChanged = Signals.createSignal(Boolean.class, (String)"inverted");
    public Signal<?, ?, ?, ?, ?> replaceText = Signals.createSignal();
    public Signal<?, ?, ?, ?, ?> mustRefresh = Signals.createSignal();
    public Signal<?, ?, ?, ?, ?> printPreviewDocket = Signals.createSignal();
    public Signal<Boolean, ?, ?, ?, ?> showNotVisibleChanged = Signals.createSignal(Boolean.class, (String)"showNotVisible");
    public Signal<String, ?, ?, ?, ?> hourFormatChanged = Signals.createSignal(String.class, (String)"hourFormat");
    public Signal<?, ?, ?, ?, ?> accountTypeChanged = Signals.createSignal();
    public Signal<?, ?, ?, ?, ?> printerChanged = Signals.createSignal();
    public Signal<?, ?, ?, ?, ?> terminalChanged = Signals.createSignal();
    public Signal<?, ?, ?, ?, ?> previous = Signals.createSignal();
    public Signal<?, ?, ?, ?, ?> next = Signals.createSignal();
    public Signal<String, ?, ?, ?, ?> displayXmlResult = Signals.createSignal(String.class, (String)"type of result to display");
    public Signal<Boolean, ?, ?, ?, ?> transferChanged = Signals.createSignal(Boolean.class, (String)"transfer has changed");
    private ComboBoxModel printerModel = new DefaultComboBoxModel<Object>(this.getPhysicalPrinters().toArray());
    private ComboBoxModel terminalModel = new DefaultComboBoxModel<Object>(Terminal.getAllWaiterMateTerminals().toArray());
    private JComboBox accountTypeSelector;
    private ButtonGroup alignGroup;
    private JToggleButton centerButton;
    private JPopupMenu extraMenu;
    private ButtonGroup hourFormatGroup;
    private JScrollPane jScrollPane1;
    private JToggleButton leftButton;
    private JButton nextButton;
    private JButton previousButton;
    private JComboBox printerSelector;
    private JRadioButton radio12h;
    private JRadioButton radio24h;
    private JToggleButton redButton;
    private JButton refresh;
    private JButton printButton;
    private JToggleButton rightButton;
    private JLabel selectionLabel;
    private JMenuItem showHtmlResult;
    private JCheckBox showInvisible;
    private JMenuItem showXmlResult;
    private JToggleButton tallButton;
    private JComboBox terminalSelector;
    private JToolBar toolBar;
    private JCheckBox transfert;
    private JEditorPane viewPane;
    private JToggleButton visibleButton;
    private JToggleButton wideButton;
    private JToggleButton underlineToggle;
    private JToggleButton invertedToggle;
    private JButton replaceButton;

    public DocketTemplateLinesViewer() {
        this.initComponents();
        this.viewPane.setComponentPopupMenu(this.extraMenu);
    }

    void setViewAlignCenter(boolean b) {
        this.centerButton.setSelected(b);
    }

    void setViewAlignLeft(boolean b) {
        this.leftButton.setSelected(b);
    }

    void setViewAlignRight(boolean b) {
        this.rightButton.setSelected(b);
    }

    void setViewColorRed(boolean b) {
        this.redButton.setSelected(b);
    }

    void setViewVisible(boolean b) {
        this.visibleButton.setSelected(b);
    }

    void setViewWeightTall(boolean b) {
        this.tallButton.setSelected(b);
    }

    void setViewWeightWide(boolean b) {
        this.wideButton.setSelected(b);
    }

    void setViewUnderline(String underlineOption) {
        this.underlineToggle.setSelected(underlineOption != null);
    }

    void setViewInverted(boolean value) {
        this.invertedToggle.setSelected(value);
    }

    private List<VirtualPrinter> getPhysicalPrinters() {
        ArrayList<VirtualPrinter> physicalPrinters = new ArrayList<VirtualPrinter>();
        List allPrinters = VirtualPrinter.getAllPrinters();
        for (VirtualPrinter virtualPrinter : allPrinters) {
            if (PhysicalPrintDeviceType.ktsPrinter.equals((Object)virtualPrinter.getPrintDevice().getPrintDeviceType())) continue;
            physicalPrinters.add(virtualPrinter);
        }
        return physicalPrinters;
    }

    void setViewReplace(String replace) {
        if (replace == null) {
            this.replaceButton.setText("Replace");
        } else if (replace.length() > 10) {
            this.replaceButton.setText("Replace " + replace.substring(0, 10));
        } else {
            this.replaceButton.setText("Replace " + replace);
        }
    }

    void setViewHourFormat(String format) {
        if (format.equals("12h")) {
            this.radio12h.setSelected(true);
        } else {
            this.radio24h.setSelected(true);
        }
    }

    void enableToobar(boolean enabled) {
        this.centerButton.setSelected(false);
        this.leftButton.setSelected(false);
        this.rightButton.setSelected(false);
        this.redButton.setSelected(false);
        this.visibleButton.setSelected(false);
        this.tallButton.setSelected(false);
        this.wideButton.setSelected(false);
        this.invertedToggle.setSelected(false);
        this.underlineToggle.setSelected(false);
        this.centerButton.setEnabled(enabled);
        this.leftButton.setEnabled(enabled);
        this.rightButton.setEnabled(enabled);
        this.redButton.setEnabled(enabled);
        this.visibleButton.setEnabled(enabled);
        this.tallButton.setEnabled(enabled);
        this.wideButton.setEnabled(enabled);
        this.invertedToggle.setEnabled(enabled);
        this.underlineToggle.setEnabled(enabled);
        this.replaceButton.setEnabled(enabled);
    }

    private void doChangeTerminal() {
        this.terminalChanged.emit();
    }

    private void doChangePrinter() {
        this.printerChanged.emit();
    }

    private void doAlignChanged() {
        String attribute = "left";
        attribute = this.rightButton.isSelected() ? "right" : (this.centerButton.isSelected() ? "center" : "left");
        this.alignChanged.emit((Object)attribute);
    }

    private void doCaretUpdate() {
        EditorKit editorKit = this.viewPane.getEditorKit();
        StringWriter sw = new StringWriter();
        try {
            editorKit.write(sw, this.viewPane.getDocument(), this.viewPane.getSelectionStart(), this.viewPane.getSelectionEnd() - this.viewPane.getSelectionStart());
        }
        catch (Exception ex) {
            this.selectionLabel.setText(ex.toString());
            OfficeMate.LOG.error((Object)ex);
        }
        sw.flush();
        String tag = this.doSearchIdTag(sw.toString());
        this.enableToobar(tag != null);
        this.nameSelected.emit((Object)tag);
    }

    private void doAccountTypeChanged() {
        this.accountTypeChanged.emit();
    }

    private void doHourFormatChanged(String format) {
        this.hourFormatChanged.emit((Object)format);
    }

    private void doColorChanged() {
        String attribute = "black";
        if (this.redButton.isSelected()) {
            attribute = "red";
        }
        this.colorChanged.emit((Object)attribute);
    }

    private void doNext() {
        this.next.emit();
    }

    private void doPrevious() {
        this.previous.emit();
    }

    private void doRefresh() {
        this.mustRefresh.emit();
    }

    private void doPrint() {
        this.printPreviewDocket.emit();
    }

    private String doSearchIdTag(String selected) {
        int lastTag = selected.lastIndexOf("<span");
        if (lastTag < 0) {
            lastTag = selected.lastIndexOf("<div");
        }
        if (lastTag < 0) {
            lastTag = selected.lastIndexOf("<hr");
        }
        if (lastTag < 0) {
            this.selectionLabel.setText("Selected line: [no tag found]");
            return null;
        }
        int endTag = selected.indexOf(">", lastTag);
        if (endTag < 0) {
            this.selectionLabel.setText("Selected line: [tag not closed]");
            return null;
        }
        String theTag = selected.substring(lastTag, endTag + 1);
        int idPos = theTag.indexOf("id=\"");
        if (idPos < 0) {
            this.selectionLabel.setText("Selected line: [no id in " + theTag + "]");
            return null;
        }
        int endId = theTag.indexOf("\"", idPos + 5);
        if (endId < 0) {
            this.selectionLabel.setText("Selected line: [incorrect id definition in " + theTag + "]");
            return null;
        }
        String theId = theTag.substring(idPos + 4, endId);
        this.selectionLabel.setText("Selected line name: " + theId);
        return theId;
    }

    private void doShowNotVisible() {
        this.showNotVisibleChanged.emit((Object)this.showInvisible.isSelected());
    }

    private void doShowXmlResult(String type) {
        this.displayXmlResult.emit((Object)type);
    }

    private void doTransferChanged() {
        this.transferChanged.emit((Object)this.transfert.isSelected());
    }

    private void doVisibleChanged() {
        String attribute = "false";
        if (this.visibleButton.isSelected()) {
            attribute = "true";
        }
        this.visibleChanged.emit((Object)attribute);
    }

    private void doWeightChanged() {
        String attribute = "none";
        if (this.tallButton.isSelected() && this.wideButton.isSelected()) {
            attribute = "big";
        } else if (this.tallButton.isSelected()) {
            attribute = "tall";
        } else if (this.wideButton.isSelected()) {
            attribute = "wide";
        }
        this.weightChanged.emit((Object)attribute);
    }

    private void doUnderlineChanged() {
        String value = null;
        if (this.underlineToggle.isSelected()) {
            value = "thick";
        }
        this.underlineChanged.emit((Object)value);
    }

    private void doInvertedChanged() {
        this.invertedChanged.emit((Object)this.invertedToggle.isSelected());
    }

    private ComboBoxModel getPrintersModel() {
        return this.printerModel;
    }

    private ComboBoxModel getUsersModel() {
        return this.terminalModel;
    }

    private void initComponents() {
        LineChangedListener listener = new LineChangedListener();
        this.hourFormatGroup = new ButtonGroup();
        this.alignGroup = new ButtonGroup();
        this.extraMenu = new JPopupMenu();
        this.showXmlResult = new JMenuItem();
        this.showHtmlResult = new JMenuItem();
        this.jScrollPane1 = new JScrollPane();
        this.viewPane = new JEditorPane();
        this.toolBar = new JToolBar();
        this.tallButton = new JToggleButton();
        this.redButton = new JToggleButton();
        this.wideButton = new JToggleButton();
        this.visibleButton = new JToggleButton();
        this.leftButton = new JToggleButton();
        this.centerButton = new JToggleButton();
        this.rightButton = new JToggleButton();
        this.underlineToggle = new JToggleButton("Underline");
        this.invertedToggle = new JToggleButton("Invert");
        this.replaceButton = new JButton("Replace");
        this.replaceButton.addActionListener(listener);
        this.selectionLabel = new JLabel();
        this.showInvisible = new JCheckBox();
        this.radio24h = new JRadioButton();
        this.radio12h = new JRadioButton();
        this.refresh = new JButton();
        this.printButton = new JButton();
        this.accountTypeSelector = new JComboBox();
        this.printerSelector = new JComboBox();
        this.terminalSelector = new JComboBox();
        this.previousButton = new JButton();
        this.nextButton = new JButton();
        this.transfert = new JCheckBox();
        this.showXmlResult.setText("Show xml result");
        this.showXmlResult.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocketTemplateLinesViewer.this.showXmlResultActionPerformed(evt);
            }
        });
        this.extraMenu.add(this.showXmlResult);
        this.showHtmlResult.setText("Show html");
        this.showHtmlResult.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocketTemplateLinesViewer.this.showHtmlResultActionPerformed(evt);
            }
        });
        this.extraMenu.add(this.showHtmlResult);
        this.viewPane.setContentType("text/html");
        this.viewPane.setEditable(false);
        this.viewPane.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent evt) {
                DocketTemplateLinesViewer.this.viewPaneCaretUpdate(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.viewPane);
        this.toolBar.setRollover(true);
        this.tallButton.setFont(new Font("Courier Tall", 0, 12));
        this.tallButton.setText("Tall");
        this.tallButton.setFocusable(false);
        this.tallButton.setVerticalTextPosition(3);
        this.tallButton.addActionListener(listener);
        this.toolBar.add(this.tallButton);
        this.redButton.setFont(new Font("Courier New", 0, 12));
        this.redButton.setForeground(new Color(255, 0, 51));
        this.redButton.setText("Red");
        this.redButton.setFocusable(false);
        this.redButton.setVerticalTextPosition(3);
        this.redButton.addActionListener(listener);
        this.toolBar.add(this.redButton);
        this.wideButton.setFont(new Font("Courier Wide", 0, 12));
        this.wideButton.setText("Wide");
        this.wideButton.setFocusable(false);
        this.wideButton.addActionListener(listener);
        this.toolBar.add(this.wideButton);
        this.visibleButton.setText("Visible");
        this.visibleButton.setFocusable(false);
        this.visibleButton.addActionListener(listener);
        this.toolBar.add(this.visibleButton);
        this.alignGroup.add(this.leftButton);
        this.leftButton.setText("Left");
        this.leftButton.setFocusable(false);
        this.leftButton.setVerticalTextPosition(3);
        this.leftButton.addActionListener(listener);
        this.toolBar.add(this.leftButton);
        this.alignGroup.add(this.centerButton);
        this.centerButton.setText("Center");
        this.centerButton.setFocusable(false);
        this.centerButton.setHorizontalTextPosition(0);
        this.centerButton.setVerticalTextPosition(3);
        this.centerButton.addActionListener(listener);
        this.toolBar.add(this.centerButton);
        this.alignGroup.add(this.rightButton);
        this.rightButton.setText("Right");
        this.rightButton.setFocusable(false);
        this.rightButton.setVerticalTextPosition(3);
        this.rightButton.addActionListener(listener);
        this.toolBar.add(this.rightButton);
        this.underlineToggle.addActionListener(listener);
        this.toolBar.add(this.underlineToggle);
        this.invertedToggle.addActionListener(listener);
        this.toolBar.add(this.invertedToggle);
        this.toolBar.add(this.replaceButton);
        this.selectionLabel.setFont(new Font("Tahoma", 1, 11));
        this.selectionLabel.setText("Selected line name: <undefined>");
        this.showInvisible.setText("Show not visible lines");
        this.showInvisible.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DocketTemplateLinesViewer.this.doShowNotVisible();
            }
        });
        this.hourFormatGroup.add(this.radio24h);
        this.radio24h.setText("24h");
        this.radio24h.setToolTipText("Display the hour from 0 to 23");
        this.radio24h.addActionListener(listener);
        this.hourFormatGroup.add(this.radio12h);
        this.radio12h.setText("12h");
        this.radio12h.setToolTipText("Display the hour from 1 to 12");
        this.radio12h.addActionListener(listener);
        this.refresh.setText("Refresh");
        this.refresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocketTemplateLinesViewer.this.refreshActionPerformed(evt);
            }
        });
        this.printButton.setText("Print");
        this.printButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DocketTemplateLinesViewer.this.printButtonActionPerformed(ae);
            }
        });
        JPanel refreshPrintPanel = new JPanel();
        GridLayout gridLayout = new GridLayout(1, 2, 5, 0);
        refreshPrintPanel.setLayout(gridLayout);
        refreshPrintPanel.add(this.refresh);
        refreshPrintPanel.add(this.printButton);
        this.accountTypeSelector.setModel(new DefaultComboBoxModel<Object>(AccountType.register.values().toArray()));
        this.accountTypeSelector.setRenderer(new DisplayableListCellRenderer());
        this.accountTypeSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocketTemplateLinesViewer.this.accountTypeSelectorActionPerformed(evt);
            }
        });
        ComponentUtils.setupComboBox((JComboBox)this.accountTypeSelector);
        this.printerSelector.setModel(this.getPrintersModel());
        this.printerSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocketTemplateLinesViewer.this.printerSelectorActionPerformed(evt);
            }
        });
        ComponentUtils.setupComboBox((JComboBox)this.printerSelector);
        this.terminalSelector.setModel(this.getUsersModel());
        this.terminalSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocketTemplateLinesViewer.this.terminalSelectorActionPerformed(evt);
            }
        });
        ComponentUtils.setupComboBox((JComboBox)this.terminalSelector);
        this.previousButton.setIcon(new ImageIcon(this.getClass().getResource("/ordermate/images/1leftarrow.png")));
        this.previousButton.setToolTipText("Previous account");
        this.previousButton.setMargin(new Insets(2, 2, 2, 2));
        this.previousButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocketTemplateLinesViewer.this.previousButtonActionPerformed(evt);
            }
        });
        this.nextButton.setIcon(new ImageIcon(this.getClass().getResource("/ordermate/images/1rightarrow.png")));
        this.nextButton.setToolTipText("Next account");
        this.nextButton.setMargin(new Insets(2, 2, 2, 2));
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocketTemplateLinesViewer.this.nextButtonActionPerformed(evt);
            }
        });
        this.transfert.setText("Transfer docket");
        this.transfert.addActionListener(listener);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 345, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.toolBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(refreshPrintPanel)).addComponent(this.selectionLabel, -1, 345, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.accountTypeSelector, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.printerSelector, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.terminalSelector, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.showInvisible).addComponent(this.transfert)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radio12h).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.radio24h))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 62, Short.MAX_VALUE).addComponent(this.previousButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nextButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.toolBar, -2, 25, -2).addComponent(refreshPrintPanel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 456, Short.MAX_VALUE).addGap(3, 3, 3).addComponent(this.selectionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.showInvisible).addComponent(this.radio12h).addComponent(this.radio24h)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.transfert).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.accountTypeSelector, -2, -1, -2).addComponent(this.printerSelector, -2, -1, -2).addComponent(this.terminalSelector, -2, -1, -2))).addComponent(this.nextButton).addComponent(this.previousButton)).addContainerGap()));
        this.selectionLabel.getAccessibleContext().setAccessibleName("Selected line name: undefined");
    }

    private void viewPaneCaretUpdate(CaretEvent evt) {
        this.doCaretUpdate();
    }

    private void refreshActionPerformed(ActionEvent evt) {
        this.doRefresh();
    }

    private void printButtonActionPerformed(ActionEvent evt) {
        this.doPrint();
    }

    private void accountTypeSelectorActionPerformed(ActionEvent evt) {
        this.doAccountTypeChanged();
    }

    private void printerSelectorActionPerformed(ActionEvent evt) {
        this.doChangePrinter();
    }

    private void terminalSelectorActionPerformed(ActionEvent evt) {
        this.doChangeTerminal();
    }

    private void previousButtonActionPerformed(ActionEvent evt) {
        this.doPrevious();
    }

    private void nextButtonActionPerformed(ActionEvent evt) {
        this.doNext();
    }

    private void showXmlResultActionPerformed(ActionEvent evt) {
        this.doShowXmlResult("xml");
    }

    private void showHtmlResultActionPerformed(ActionEvent evt) {
        this.doShowXmlResult("html");
    }

    public void setView(String html) {
        int pos = this.viewPane.getCaretPosition();
        this.viewPane.setContentType("text/html");
        this.viewPane.setText(html);
        int newPos = this.viewPane.getCaretPosition();
        if (newPos >= pos) {
            this.viewPane.setCaretPosition(pos);
        } else {
            this.viewPane.setCaretPosition(0);
        }
    }

    public String getViewText() {
        return this.viewPane.getText();
    }

    public void setTextView(String text) {
        this.viewPane.setContentType("text/plain");
        this.viewPane.setText(text);
    }

    public AccountType getSelectedAccountType() {
        return (AccountType)this.accountTypeSelector.getSelectedItem();
    }

    public VirtualPrinter getSelectedPrinter() {
        return (VirtualPrinter)this.printerModel.getSelectedItem();
    }

    public Terminal getSelectedTerminal() {
        return (Terminal)this.terminalModel.getSelectedItem();
    }

    class LineChangedListener
    implements ActionListener {
        LineChangedListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == DocketTemplateLinesViewer.this.redButton) {
                DocketTemplateLinesViewer.this.doColorChanged();
            } else if (source == DocketTemplateLinesViewer.this.visibleButton) {
                DocketTemplateLinesViewer.this.doVisibleChanged();
            } else if (source == DocketTemplateLinesViewer.this.transfert) {
                DocketTemplateLinesViewer.this.doTransferChanged();
            } else if (source == DocketTemplateLinesViewer.this.tallButton || source == DocketTemplateLinesViewer.this.wideButton) {
                DocketTemplateLinesViewer.this.doWeightChanged();
            } else if (source == DocketTemplateLinesViewer.this.leftButton || source == DocketTemplateLinesViewer.this.centerButton || source == DocketTemplateLinesViewer.this.rightButton) {
                DocketTemplateLinesViewer.this.doAlignChanged();
            } else if (source == DocketTemplateLinesViewer.this.underlineToggle) {
                DocketTemplateLinesViewer.this.doUnderlineChanged();
            } else if (source == DocketTemplateLinesViewer.this.invertedToggle) {
                DocketTemplateLinesViewer.this.doInvertedChanged();
            } else if (source == DocketTemplateLinesViewer.this.replaceButton) {
                DocketTemplateLinesViewer.this.replaceText.emit();
            } else if (source == DocketTemplateLinesViewer.this.radio24h) {
                DocketTemplateLinesViewer.this.doHourFormatChanged("24h");
            } else if (source == DocketTemplateLinesViewer.this.radio12h) {
                DocketTemplateLinesViewer.this.doHourFormatChanged("12h");
            }
            DocketTemplateLinesViewer.this.doRefresh();
        }
    }
}

