/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.printing;

import au.com.ordermate.gui.ObjectEditor;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.table.TableCellEditor;
import officemate.components.EditorDialog;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.EditablePropertyColumnFormat;
import officemate.components.tableformat.PopupEditableColumnFormat;
import officemate.components.tableformat.renderers.AutoCompleteComboCellEditor;
import officemate.components.tableformat.textformat.DisplayableListFormat;
import officemate.screens.setup.configuration.printing.DocketTemplateLinesEditor;
import officemate.screens.setup.configuration.printing.DocketTemplateTriggersEditor;
import ordermate.database.docket.DocketTemplate;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.inventory.triggers.activation.StrategyRegister;
import ordermate.database.inventory.triggers.activation.TriggerActivationStrategy;
import ordermate.database.stock.StockControlProperty;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class DocketTemplateState
extends AbstractEditableTableState<DocketTemplate> {
    private EventList<AbstractTrigger> triggers = new BasicEventList();
    private EventList<TriggerActivationStrategy> triggerActivations = new BasicEventList();

    public DocketTemplateState() {
        super("Docket Templates", null, "Manage the Docket Templates.");
        this.triggerActivations.addAll(StrategyRegister.getAllStrategies());
    }

    @Override
    protected EditorDialog createEditorDialog() {
        return new EditorDialog(this.getTypeName(), this.getObjectEditor(), "Template editor", "Template editor, click OK to confirm, cancel otherwise.");
    }

    @Override
    public ObjectEditor<DocketTemplate> createObjectEditor() {
        return new DocketTemplateLinesEditor();
    }

    @Override
    public String getTypeName() {
        return "Docket Template";
    }

    @Override
    public TableStateCentralArea<DocketTemplate> createCentralArea() {
        this.setFilterActive(true);
        PersistentObjectTable<DocketTemplate> table = new PersistentObjectTable<DocketTemplate>(this.getObjectList(), new ColumnTableFormat(new ColumnFormat[]{new PropertyColumnFormat(DocketTemplate.Properties.TYPE), new EditablePropertyColumnFormat(DocketTemplate.Properties.TEMPLATE_NAME), new EditablePropertyColumnFormat(DocketTemplate.Properties.SEQUENCE), new EditablePropertyColumnFormat(DocketTemplate.Properties.TRIGGER_ACTIVATION_STRATEGY).setCustomEditor((TableCellEditor)((Object)new AutoCompleteComboCellEditor(this.triggerActivations))), new PopupEditableColumnFormat(DocketTemplate.Properties.TRIGGERS, new DocketTemplateTriggersEditor((EventList)this.triggers), this).setFormatter(new DisplayableListFormat(true))}));
        return table;
    }

    @Override
    public Class<DocketTemplate> getDisplayingType() {
        return DocketTemplate.class;
    }

    @Override
    protected DocketTemplate createNewObject() {
        Set<DocketTemplate.DocketType> docketTypes = this.createListOfCreatableTemplateTypes();
        DocketTemplate.DocketType type = (DocketTemplate.DocketType)JOptionPane.showInputDialog(this.getCentralArea().getComponent(), "Select the docket type:", "New docket template type selection", -1, null, docketTypes.toArray(), "Prep docket");
        DocketTemplate retValue = null;
        if (type != null) {
            retValue = new DocketTemplate(type);
            retValue.addTrigger((AbstractTrigger)AbstractTrigger.getDefaultTriggerIfExists());
        }
        return retValue;
    }

    private Set<DocketTemplate.DocketType> createListOfCreatableTemplateTypes() {
        HashSet<DocketTemplate.DocketType> docketTypes = new HashSet<DocketTemplate.DocketType>(DocketTemplate.DocketType.register.values());
        if (!StockControlProperty.getInstance().isStockControlEnabled()) {
            for (DocketTemplate.DocketType dockType : new ArrayList<DocketTemplate.DocketType>(docketTypes)) {
                if (!dockType.isStockDocket()) continue;
                docketTypes.remove(dockType);
            }
        }
        return docketTypes;
    }

    @Override
    public void refresh() {
        this.triggers.clear();
        this.triggers.addAll((Collection)AbstractTrigger.getUserLinkableTriggers());
        super.refresh();
    }
}

