/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.printing;

import au.com.ordermate.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import officemate.screens.setup.configuration.printing.ReplacementPanel;
import ordermate.OrderMate;

class ReplaceTextPanel
extends JPanel {
    private JPanel holder;
    private JScrollPane scrolly;
    private List<ReplacementPanel> panels = new ArrayList<ReplacementPanel>();
    private JButton addButton;

    public ReplaceTextPanel() {
        super(new BorderLayout());
        this.setupComponents();
    }

    private void setupComponents() {
        this.holder = new JPanel();
        this.holder.setLayout(new BoxLayout(this.holder, 1));
        this.scrolly = new JScrollPane(this.holder);
        this.add((Component)this.scrolly, "Center");
        this.addButton = new JButton("Add...");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReplaceTextPanel.this.addNew();
            }
        });
        this.add((Component)this.addButton, "South");
        this.updatePanels();
    }

    private void addNew() {
        if (this.panels.size() < 5) {
            this.panels.add(new ReplacementPanel());
            this.updatePanels();
            this.holder.invalidate();
            this.scrolly.validate();
        }
    }

    private void updatePanels() {
        this.holder.removeAll();
        for (ReplacementPanel panel : this.panels) {
            this.holder.add(panel);
        }
    }

    public void setText(String replacementText) {
        this.panels.clear();
        List splits = StringUtils.splitToList((String)replacementText, (String)";");
        for (String split : splits) {
            try {
                int index = split.indexOf("=");
                if (index <= 0) continue;
                String key = split.substring(0, index);
                String value = split.substring(index + 1);
                if (key.isEmpty()) continue;
                ReplacementPanel panel = new ReplacementPanel();
                panel.setKey(key);
                panel.setValue(value);
                this.panels.add(panel);
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot replace string in text", (Throwable)ex);
            }
        }
        if (this.panels.isEmpty()) {
            this.panels.add(new ReplacementPanel());
        }
        this.updatePanels();
    }

    public String getText() {
        StringBuilder SB = new StringBuilder();
        for (ReplacementPanel panel : this.panels) {
            String key = panel.getKey();
            if (key == null || key.length() == 0) continue;
            if (SB.length() > 0) {
                SB.append(";");
            }
            SB.append(key).append("=").append(panel.getValue());
        }
        this.panels.clear();
        if (SB.length() == 0) {
            return null;
        }
        return SB.toString();
    }
}

