/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.report.config;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;
import officemate.components.AbstractObjectEditor;
import officemate.screens.setup.configuration.report.config.ReportConfigFilterEditor;
import officemate.screens.setup.configuration.report.config.ReportConfigPropertyEditor;
import ordermate.database.config.report.ReportConfig;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.binding.validators.NotEmptyValidator;
import org.jdesktop.beansbinding.Validator;

public class ReportConfigEditor
extends AbstractObjectEditor<ReportConfig> {
    private JLabel typeLabel;
    private ReportConfigFilterEditor filterEditor;
    private ReportConfigPropertyEditor propertyEditor;

    public ReportConfigEditor() {
        this.setLayout(new BoxLayout(this, 1));
        this.setupComponents();
    }

    private void setupComponents() {
        FieldPanelBuilder builder = new FieldPanelBuilder();
        JTextField component = this.setupTextField(ReportConfig.Properties.LABEL, 20, (Validator)new NotEmptyValidator());
        builder.addRow("Label", (Component)component);
        this.typeLabel = new JLabel("-");
        builder.addRow("Type", (Component)this.typeLabel);
        this.add(builder.getPanel());
        this.filterEditor = new ReportConfigFilterEditor();
        this.filterEditor.setPreferredSize(new Dimension(400, 200));
        this.add(this.filterEditor);
        this.propertyEditor = new ReportConfigPropertyEditor();
        this.propertyEditor.setPreferredSize(new Dimension(400, 200));
        this.add(this.propertyEditor);
    }

    @Override
    public void setObject(ReportConfig value) {
        super.setObject(value);
        this.typeLabel.setText(value.getType());
        this.filterEditor.setObject(value);
        this.propertyEditor.setObject(value);
    }

    @Override
    public void saveObject() {
        super.saveObject();
        this.filterEditor.saveObject();
        this.propertyEditor.saveObject();
    }
}

