/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.report.config;

import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.Executable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.StringUtils;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.view.JasperViewer;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.wizard.GenericWizard;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.screens.setup.configuration.report.config.ReportConfigEditor;
import officemate.screens.setup.configuration.report.config.wizard.ReportConfigWizardState;
import ordermate.OrderMate;
import ordermate.database.config.report.ReportConfig;
import ordermate.database.config.report.ReportConfigSchedule;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.reports.maker.ConfigurableReportMaker;
import ordermate.database.reports.maker.OMReportMakerFactory;
import ordermate.database.users.AllPermissions;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;
import ordermate.services.misc.CallMethodOnClassExecutable;
import org.apache.commons.io.FilenameUtils;

public class ReportConfigState
extends AbstractEditableTableState<ReportConfig> {
    public ReportConfigState() {
        super("Report Config", AllPermissions.ACCOUNT_ADMIN, "Setup configurable reports");
        this.addSelectionDependentAction(new AbstractAction("Run Report", IconLoader.get((String)"/ordermate/images/view_report.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                final ReportConfig config = (ReportConfig)ReportConfigState.this.getCentralArea().getSelectedObject();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ConfigurableReportMaker maker = OMReportMakerFactory.getInstance().createReportMaker(config);
                        JasperPrint print = null;
                        try {
                            print = maker.createJasperReport();
                        }
                        catch (Exception ex) {
                            OrderMate.LOG.error("Cannot create sample", (Throwable)ex);
                        }
                        if (print != null) {
                            JasperViewer.viewReport((JasperPrint)print, (boolean)false);
                        } else {
                            Dialogs.showWarningDialog("No Report", "The report cannot be shown, please check logs");
                        }
                    }
                });
            }
        });
        this.addSelectionDependentAction(new AbstractAction("Run CSV", IconLoader.get((String)"/ordermate/images/view_report.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                final ReportConfig config = (ReportConfig)ReportConfigState.this.getCentralArea().getSelectedObject();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ConfigurableReportMaker maker = OMReportMakerFactory.getInstance().createReportMaker(config);
                            String csv = maker.createCsv();
                            JFileChooser chooser = new JFileChooser();
                            chooser.setAcceptAllFileFilterUsed(false);
                            FileNameExtensionFilter filter = new FileNameExtensionFilter("Excel Documents", "csv");
                            chooser.addChoosableFileFilter(filter);
                            int response = chooser.showSaveDialog(null);
                            if (response == 0) {
                                File file = chooser.getSelectedFile();
                                if (!FilenameUtils.getExtension((String)file.getName()).equalsIgnoreCase("csv")) {
                                    file = new File(file.getParentFile(), FilenameUtils.getBaseName((String)file.getName()) + ".csv");
                                }
                                StringUtils.writeTextToFile((File)file, (String)csv);
                            }
                        }
                        catch (Exception ex) {
                            OrderMate.LOG.error("Cannot create sample", (Throwable)ex);
                        }
                    }
                });
            }
        });
    }

    @Override
    protected ObjectEditor<ReportConfig> createObjectEditor() {
        return new ReportConfigEditor();
    }

    @Override
    public String getTypeName() {
        return "Report Configuration";
    }

    @Override
    protected TableStateCentralArea<ReportConfig> createCentralArea() {
        ColumnTableFormat format = new ColumnTableFormat();
        format.addColumn((ColumnFormat)new PropertyColumnFormat(ReportConfig.Properties.LABEL));
        format.addColumn((ColumnFormat)new PropertyColumnFormat(ReportConfig.Properties.TYPE));
        this.getSearchFactory().setSystemStateFilterActive(true);
        PersistentObjectTable<ReportConfig> table = new PersistentObjectTable<ReportConfig>(this.getObjectList(), format);
        return table;
    }

    @Override
    protected Class<ReportConfig> getDisplayingType() {
        return ReportConfig.class;
    }

    @Override
    protected ReportConfig createNewObject() {
        GenericWizard wizard = new GenericWizard(new ReportConfigWizardState(), new Dimension(450, 400));
        this.refresh();
        return null;
    }

    @Override
    public void gotObjectDeleted(ReportConfig toDelete) {
        List danglingSchedules = PersistenceManager.getObjectList(ReportConfigSchedule.class, (String)Query.select(ReportConfigSchedule.class).equals(ReportConfigSchedule.Properties.REPORT_CONFIG, (Object)toDelete).toString());
        if (!danglingSchedules.isEmpty()) {
            for (ReportConfigSchedule schedule : danglingSchedules) {
                schedule.setSystemState(SystemState.INACTIVE_STATE);
                schedule.save();
            }
            PersistenceManager.getServerConnection().runSync((Executable)new CallMethodOnClassExecutable("ordermate.reports.email.EmailReportTask", new String[]{"scheduleAllReports"}));
            for (ReportConfigSchedule schedule : danglingSchedules) {
                schedule.delete();
            }
        }
        super.gotObjectDeleted(toDelete);
    }
}

