/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.report.config.schedule;

import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.gui.renderer.JCheckBoxCellRenderer;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.Executable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.reports.ReportOutput;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.table.TableCellEditor;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.wizard.GenericWizard;
import officemate.components.GeneralChooseElementsObjectEditor;
import officemate.components.strategy.SaveStrategyFactory;
import officemate.components.strategy.StrategySaveCancelListener;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.EditablePropertyColumnFormat;
import officemate.components.tableformat.PopupEditableColumnFormat;
import officemate.components.tableformat.renderers.AutoCompleteComboCellEditor;
import officemate.components.tableformat.renderers.CronExpCellEditor;
import officemate.screens.setup.configuration.report.config.schedule.wizard.ReportConfigScheduleSelectionWizardState;
import ordermate.database.config.report.ReportConfigSchedule;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.User;
import ordermate.gui.dialogs.UserRenderer;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;
import ordermate.services.misc.CallMethod;
import ordermate.services.misc.CallMethodOnClassExecutable;

public class ReportConfigScheduleState
extends AbstractEditableTableState<ReportConfigSchedule> {
    private EventList<User> users;
    private ObjectQuery userQuery;
    private BasicAction sendNow;

    public ReportConfigScheduleState() {
        super("Schedule Reports", AllPermissions.ACCOUNT_ADMIN, "Schedule your reports");
        this.setSaveStrategy(SaveStrategyFactory.getInstantSaveStrategy());
        this.getSaveStrategy().addSaveCancelListener(new StrategySaveCancelListener(){

            @Override
            public void preSave() {
            }

            @Override
            public void preCancel() {
            }

            @Override
            public void postSave() {
                ReportConfigScheduleState.this.updateSchedules();
            }
        });
        this.sendNow = new BasicAction("Send Report"){

            public void actionPerformed(ActionEvent e) {
                ReportConfigSchedule report = (ReportConfigSchedule)ReportConfigScheduleState.this.getCentralArea().getSelectedObject();
                if (report != null) {
                    PersistenceManager.getServerConnection().runSync((Executable)new CallMethodOnClassExecutable("ordermate.reports.email.EmailReportTaskMaster", new CallMethod[]{new CallMethod("getInstance", new Serializable[0]), new CallMethod("emailReport", new Serializable[]{report})}));
                    Dialogs.showInfoDialog("Report Sent", "Please check the email for the report. If this didn't work, please check the Servermate logs.");
                }
            }
        };
        this.addSelectionDependentAction((Action)this.sendNow);
    }

    @Override
    protected ObjectEditor<ReportConfigSchedule> createObjectEditor() {
        return null;
    }

    @Override
    public String getTypeName() {
        return "Scheduled Report";
    }

    @Override
    protected TableStateCentralArea<ReportConfigSchedule> createCentralArea() {
        this.userQuery = Query.select(User.class).active(User.class).not().isNull(User.Properties.EMAIL).wherePropertyLike(User.Properties.EMAIL, "%@%");
        this.users = GlazedLists.eventList((Collection)PersistenceManager.getObjectList(User.class, (String)this.userQuery.toString()));
        GeneralChooseElementsObjectEditor chooser = new GeneralChooseElementsObjectEditor((PropertiedObject.Property<User>)ReportConfigSchedule.Properties.USER_LIST, this.users);
        JCheckBoxCellRenderer newRenderer = new JCheckBoxCellRenderer("None");
        newRenderer.setDecoratedRenderer((DefaultListCellRenderer)new UserRenderer());
        chooser.setRenderer(newRenderer);
        ColumnTableFormat format = new ColumnTableFormat();
        format.addColumn((ColumnFormat)new PropertyColumnFormat(ReportConfigSchedule.Properties.REPORT_CONFIG));
        format.addColumn(new EditablePropertyColumnFormat(ReportConfigSchedule.Properties.CRON_SCHEDULE).setCustomEditor(new CronExpCellEditor()));
        format.addColumn(new EditablePropertyColumnFormat(ReportConfigSchedule.Properties.EMAIL));
        format.addColumn(new PopupEditableColumnFormat((PropertiedObject.Property)ReportConfigSchedule.Properties.USER_LIST, chooser, this));
        AutoCompleteComboCellEditor outputEditor = new AutoCompleteComboCellEditor(GlazedLists.eventListOf((Object[])ReportOutput.values()));
        format.addColumn(new EditablePropertyColumnFormat(ReportConfigSchedule.Properties.REPORT_OUTPUT).setCustomEditor((TableCellEditor)((Object)outputEditor)));
        this.getSearchFactory().setSystemStateFilterActive(true);
        PersistentObjectTable<ReportConfigSchedule> table = new PersistentObjectTable<ReportConfigSchedule>(this.getObjectList(), format);
        return table;
    }

    @Override
    public void onStart() {
        super.onStart();
        this.users.getReadWriteLock().writeLock().lock();
        this.users.clear();
        this.users.addAll((Collection)PersistenceManager.getObjectList(User.class, (String)this.userQuery.toString()));
        this.users.getReadWriteLock().writeLock().unlock();
    }

    @Override
    public void onEnd() {
        this.users.getReadWriteLock().writeLock().lock();
        this.users.clear();
        this.users.getReadWriteLock().writeLock().unlock();
        super.onEnd();
    }

    @Override
    protected Class<ReportConfigSchedule> getDisplayingType() {
        return ReportConfigSchedule.class;
    }

    @Override
    protected ReportConfigSchedule createNewObject() {
        GenericWizard wizard = new GenericWizard(new ReportConfigScheduleSelectionWizardState(), new Dimension(450, 300));
        if (wizard.getObject() != null && ((ReportConfigSchedule)wizard.getObject()).isPersistent()) {
            return (ReportConfigSchedule)wizard.getObject();
        }
        return null;
    }

    private void updateSchedules() {
        PersistenceManager.getServerConnection().runSync((Executable)new CallMethodOnClassExecutable("ordermate.reports.email.EmailReportTask", new String[]{"scheduleAllReports"}));
    }
}

