/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.report.config.schedule.wizard;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.util.DateTimeUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import officemate.adminkit.wizard.AbstractWizardState;
import officemate.screens.setup.configuration.report.config.schedule.wizard.ReportConfigScheduleRecipientsWizardState;
import ordermate.database.config.report.ReportConfigSchedule;
import ordermate.database.config.report.ReportConfigScheduleHelper;
import ordermate.database.misc.SystemProperty;
import ordermate.scheduler.quartz.CronExpression;
import org.jdesktop.swingx.combobox.EnumComboBoxModel;

public class ReportConfigScheduleCronSetWizardState
extends AbstractWizardState
implements ActionListener {
    private JComboBox scheduleOptions;
    private JLabel nextScheduledEmail;
    private JPanel wrapper;
    private final String autoSendWarningText = "Note: Auto-send is only applicable for Reconciliation and Denomination Reports.";

    public ReportConfigScheduleCronSetWizardState() {
        super(new ReportConfigScheduleRecipientsWizardState());
    }

    @Override
    public JPanel initCentralContent() {
        this.wrapper = new JPanel(new GridLayout(2, 1));
        this.initComponents();
        this.wrapper.add((Component)this.scheduleOptions, 0);
        this.wrapper.add((Component)this.nextScheduledEmail, 1);
        return this.wrapper;
    }

    private void initComponents() {
        this.scheduleOptions = new JComboBox(new EnumComboBoxModel(ReportConfigScheduleHelper.ReportScheduleOptions.class));
        this.scheduleOptions.setRenderer(new ReportScheduleRenderer());
        this.scheduleOptions.addActionListener(this);
        this.scheduleOptions.setPreferredSize(new Dimension(450, 50));
        this.nextScheduledEmail = new JLabel();
        this.nextScheduledEmail.setHorizontalAlignment(0);
        this.setNextScheduledEmailLabel(false);
    }

    @Override
    public String getInstructionText() {
        return "When would you like this report to be sent?";
    }

    @Override
    public String getTitleBarText() {
        return "Set a schedule";
    }

    public boolean prepareForStateChange(PersistentObject object) {
        ReportConfigScheduleHelper.ReportScheduleOptions option = (ReportConfigScheduleHelper.ReportScheduleOptions)this.scheduleOptions.getSelectedItem();
        String amended = ReportConfigScheduleHelper.amendCronHourToAfterRollover((String)option.getValue());
        ((ReportConfigSchedule)object).setCronSchedule(amended);
        return true;
    }

    public void prepareForReturn(PersistentObject object) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.scheduleOptions) {
            if (((ReportConfigScheduleHelper.ReportScheduleOptions)this.scheduleOptions.getSelectedItem()).equals((Object)ReportConfigScheduleHelper.ReportScheduleOptions.AUTO_SEND_ON_COMPLETION)) {
                this.setNextScheduledEmailLabel(true);
            } else {
                this.setNextScheduledEmailLabel(false);
            }
        }
    }

    private void setNextScheduledEmailLabel(boolean appendWarning) {
        String htmlOpen = "<html><center><font size=\"4\">";
        String htmlClose = "</font></center></html>";
        String content = "The next scheduled email will be at " + this.getNextScheduledEmailTime();
        if (appendWarning) {
            content = content.concat("<br><br><i><font size=\"2\" color=\"red\">").concat("Note: Auto-send is only applicable for Reconciliation and Denomination Reports.").concat("</i></font>");
        }
        this.nextScheduledEmail.setText(htmlOpen + content + htmlClose);
    }

    private String getNextScheduledEmailTime() {
        String toReturn = "";
        ReportConfigScheduleHelper.ReportScheduleOptions option = (ReportConfigScheduleHelper.ReportScheduleOptions)this.scheduleOptions.getSelectedItem();
        if (option == null) {
            option = ReportConfigScheduleHelper.ReportScheduleOptions.DAILY;
        } else if ("@autosend".equals(option.getValue())) {
            toReturn = "the time of task completion.";
        } else if ("@tradingday".equals(option.getValue())) {
            Calendar nextFire = Calendar.getInstance();
            nextFire.setTime(new Date());
            Calendar rolloverTime = Calendar.getInstance();
            rolloverTime.setTime(SystemProperty.getInstance().getChangeDayTime());
            nextFire.set(11, rolloverTime.get(11));
            nextFire.set(12, rolloverTime.get(12));
            nextFire.roll(11, true);
            nextFire.roll(6, true);
            toReturn = DateTimeUtils.formatDateForDisplay((Date)nextFire.getTime());
        } else {
            String amended = ReportConfigScheduleHelper.amendCronHourToAfterRollover((String)option.getValue());
            CronExpression expression = null;
            try {
                expression = new CronExpression(amended);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            if (expression != null) {
                Date nextFireDate = expression.getNextValidTimeAfter(new Date());
                toReturn = DateTimeUtils.formatDateForDisplay((Date)nextFireDate);
            }
        }
        return toReturn;
    }

    private class ReportScheduleRenderer
    extends DefaultListCellRenderer {
        private ReportScheduleRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(((ReportConfigScheduleHelper.ReportScheduleOptions)value).getName());
            return this;
        }
    }
}

