/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.report.config.wizard;

import au.com.ordermate.gui.adminkit.ComponentUtils;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.wizard.AbstractWizardState;
import officemate.adminkit.wizard.WizardTextEntry;
import officemate.screens.setup.configuration.report.config.ReportConfigFilterEditor;
import ordermate.database.config.report.ReportConfig;
import ordermate.database.reports.config.custom.CustomReport;
import ordermate.database.reports.maker.ConfigurableReportMaker;
import ordermate.database.reports.maker.OMReportMakerFactory;

public class ReportConfigWizardState
extends AbstractWizardState
implements ActionListener {
    private JComboBox reportMakerList;
    private WizardTextEntry reportConfigLabelEntry;
    private JLabel filterSelectionPrompt;
    private JLabel filterDateRangeHelpLabel;
    private JLabel noFiltersLabel;
    private JPanel hotswapComponentWrapper;
    private JPanel filterPropertySetterWrapper;
    private ReportConfigFilterEditor filterEditor;
    private final String filterPromptText = "<html><b>Which filters would you like to apply to the report?</b></html>";
    private final String customPromptText = "<html><b>Which custom report would you like to create a configuration for?</b></html>";
    private final String filterDateRangeExplanation = "<html><b>Need help with date filters?</b><br><font color=\"#4C4C4C\">Example filter value for <b>Date</b> to report on 5 days ago:</font> <b>-5d</b><br><font color=\"#4C4C4C\">Example filter value for <b>Date Range</b> to report on the last 2 months:</font> <b>-2m : now</b></html>";
    private final String noFiltersPre = "<html><font size=\"5\" color=\"#666666\">The ";
    private final String noFiltersPost = " has no filters to set.</font></html>";
    private JPanel customReportSelectionWrapper;
    private JLabel customReportSelectionPrompt;
    private JComboBox customReportTypeSelection;
    private JLabel noCustomsAvailableLabel;

    public ReportConfigWizardState() {
        super(null);
    }

    @Override
    public JPanel initCentralContent() {
        JPanel toReturn = new JPanel();
        toReturn.setLayout(new BoxLayout(toReturn, 1));
        this.initComponents();
        this.reportMakerList.setAlignmentX(0.0f);
        this.reportConfigLabelEntry.setAlignmentX(0.0f);
        this.hotswapComponentWrapper.setAlignmentX(0.0f);
        toReturn.add(this.reportMakerList);
        toReturn.add(this.reportConfigLabelEntry);
        toReturn.add(this.hotswapComponentWrapper);
        return toReturn;
    }

    private void initComponents() {
        ArrayList<String> types = new ArrayList<String>();
        types.add("Select a report...");
        types.addAll(this.getReportMakersAsynchronously());
        this.reportMakerList = new JComboBox<Object>(types.toArray());
        this.reportMakerList.setPreferredSize(new Dimension(424, 50));
        this.reportMakerList.addActionListener(this);
        ComponentUtils.setupComboBox((JComboBox)this.reportMakerList);
        this.reportConfigLabelEntry = new WizardTextEntry("Enter a name for your new report configuration:");
        this.reportConfigLabelEntry.setBorder(new EmptyBorder(5, 0, 5, 0));
        this.initFilterSelectionContents();
        this.initCustomReportSelectionContents();
        this.noFiltersLabel = new JLabel();
        this.noFiltersLabel.setBorder(new EmptyBorder(0, 3, 0, 0));
        this.filterSelectionPrompt.setVisible(false);
        this.filterPropertySetterWrapper.setVisible(false);
        this.filterDateRangeHelpLabel.setVisible(false);
    }

    private void initFilterSelectionContents() {
        this.hotswapComponentWrapper = new JPanel();
        this.hotswapComponentWrapper.setLayout(new BorderLayout());
        this.filterSelectionPrompt = new JLabel("<html><b>Which filters would you like to apply to the report?</b></html>");
        this.filterSelectionPrompt.setBorder(new EmptyBorder(2, 2, 6, 0));
        this.filterEditor = new ReportConfigFilterEditor();
        this.filterEditor.setPreferredSize(new Dimension(500, 140));
        this.removeSearchButton();
        this.filterPropertySetterWrapper = new JPanel(new GridLayout(0, 1));
        this.filterPropertySetterWrapper.add((Component)this.filterEditor, 0);
        this.filterDateRangeHelpLabel = new JLabel("<html><b>Need help with date filters?</b><br><font color=\"#4C4C4C\">Example filter value for <b>Date</b> to report on 5 days ago:</font> <b>-5d</b><br><font color=\"#4C4C4C\">Example filter value for <b>Date Range</b> to report on the last 2 months:</font> <b>-2m : now</b></html>");
        this.filterDateRangeHelpLabel.setBorder(new EmptyBorder(6, 0, 0, 0));
        this.hotswapComponentWrapper.add((Component)this.filterSelectionPrompt, "First");
        this.hotswapComponentWrapper.add((Component)this.filterPropertySetterWrapper, "Center");
        this.hotswapComponentWrapper.add((Component)this.filterDateRangeHelpLabel, "Last");
    }

    private void initCustomReportSelectionContents() {
        this.customReportSelectionWrapper = new JPanel();
        this.customReportSelectionWrapper.setLayout(new BoxLayout(this.customReportSelectionWrapper, 1));
        this.customReportSelectionWrapper.setAlignmentX(0.0f);
        this.customReportSelectionPrompt = new JLabel("<html><b>Which custom report would you like to create a configuration for?</b></html>", 2);
        this.customReportSelectionPrompt.setBorder(new EmptyBorder(6, 0, 6, 0));
        List reports = PersistenceManager.getObjectList(CustomReport.class, (String)Query.select(CustomReport.class).toString());
        this.customReportTypeSelection = new JComboBox<Object>(reports.toArray());
        this.customReportTypeSelection.setPreferredSize(new Dimension(424, 50));
        this.customReportTypeSelection.setAlignmentX(0.0f);
        this.customReportTypeSelection.addActionListener(this);
        ComponentUtils.setupComboBox((JComboBox)this.customReportTypeSelection);
        this.noCustomsAvailableLabel = new JLabel("<html><i><font color=\"red\">Note: There are no custom reports set up.</font></i></html>");
        this.noCustomsAvailableLabel.setBorder(new EmptyBorder(2, 0, 0, 0));
        this.noCustomsAvailableLabel.setAlignmentX(0.0f);
        this.noCustomsAvailableLabel.setVisible(false);
        this.customReportSelectionWrapper.add(this.customReportSelectionPrompt);
        this.customReportSelectionWrapper.add(this.customReportTypeSelection);
        this.customReportSelectionWrapper.add(this.noCustomsAvailableLabel);
    }

    @Override
    public String getInstructionText() {
        return "Which report would you like to create a configuration for?";
    }

    @Override
    public String getTitleBarText() {
        return "Create a report configuration";
    }

    public boolean prepareForStateChange(PersistentObject object) {
        String selectedReport = (String)this.reportMakerList.getSelectedItem();
        if (selectedReport == null || "Select a report...".equals(selectedReport) || "Custom".equals(((ReportConfig)object).getType()) && this.customReportTypeSelection.getSelectedItem() == null) {
            Dialogs.showMessageDialog("Oops!", "Please select a valid report type for this report configuration.");
            return false;
        }
        String label = this.reportConfigLabelEntry.getInput();
        if (label != null && !label.isEmpty()) {
            ((ReportConfig)object).setLabel(label);
        }
        this.filterEditor.saveObject();
        if ("Custom".equals(selectedReport)) {
            CustomReport selectedCustomReport = (CustomReport)this.customReportTypeSelection.getSelectedItem();
            ((ReportConfig)object).getReportProperty("Custom Report").setValue(selectedCustomReport.getTitle());
        }
        ((ReportConfig)object).save();
        return true;
    }

    public void prepareForReturn(PersistentObject object) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.reportMakerList) {
            String selected = (String)this.reportMakerList.getSelectedItem();
            if ("Select a report...".equals(selected)) {
                this.filterSelectionPrompt.setVisible(false);
                this.filterPropertySetterWrapper.setVisible(false);
                this.filterDateRangeHelpLabel.setVisible(false);
            } else if ("Custom".equals(selected)) {
                this.hotswapComponentWrapper.remove(this.noFiltersLabel);
                this.hotswapComponentWrapper.validate();
                this.hotswapComponentWrapper.repaint();
                this.refreshFilterTableAndUpdateBusinessObject();
                this.filterSelectionPrompt.setVisible(true);
                this.filterPropertySetterWrapper.setVisible(true);
                this.filterDateRangeHelpLabel.setVisible(true);
                this.customReportSelectionWrapper.setVisible(true);
                if (this.customReportTypeSelection.getItemCount() < 1) {
                    this.noCustomsAvailableLabel.setVisible(true);
                }
                this.filterPropertySetterWrapper.add((Component)this.customReportSelectionWrapper, 1);
                this.filterPropertySetterWrapper.validate();
                this.filterPropertySetterWrapper.repaint();
            } else {
                if (OMReportMakerFactory.getInstance().createReportMaker(selected).getReportFilterControls().isEmpty()) {
                    this.refreshFilterTableAndUpdateBusinessObject();
                    this.filterSelectionPrompt.setVisible(false);
                    this.filterPropertySetterWrapper.setVisible(false);
                    this.filterDateRangeHelpLabel.setVisible(false);
                    this.noFiltersLabel.setText("<html><font size=\"5\" color=\"#666666\">The " + selected + " has no filters to set.</font></html>");
                    this.hotswapComponentWrapper.add((Component)this.noFiltersLabel, "West");
                    this.hotswapComponentWrapper.validate();
                    this.hotswapComponentWrapper.repaint();
                } else {
                    this.hotswapComponentWrapper.remove(this.noFiltersLabel);
                    this.hotswapComponentWrapper.validate();
                    this.hotswapComponentWrapper.repaint();
                    this.refreshFilterTableAndUpdateBusinessObject();
                    this.filterSelectionPrompt.setVisible(true);
                    if (((ReportConfig)this.filterEditor.getObject()).getFilter("Date") != null || ((ReportConfig)this.filterEditor.getObject()).getFilter("Date Range") != null) {
                        this.filterDateRangeHelpLabel.setVisible(true);
                    } else {
                        this.filterDateRangeHelpLabel.setVisible(false);
                    }
                    this.filterPropertySetterWrapper.setVisible(true);
                    this.customReportSelectionWrapper.setVisible(false);
                    this.filterPropertySetterWrapper.remove(this.filterEditor);
                    this.filterPropertySetterWrapper.remove(this.customReportSelectionWrapper);
                    this.filterPropertySetterWrapper.add(this.filterEditor);
                }
                this.filterPropertySetterWrapper.validate();
                this.filterPropertySetterWrapper.repaint();
            }
            this.validate();
            this.repaint();
        }
    }

    private void refreshFilterTableAndUpdateBusinessObject() {
        ConfigurableReportMaker maker = (ConfigurableReportMaker)OMReportMakerFactory.getInstance().createReportMaker((String)this.reportMakerList.getSelectedItem());
        ReportConfig toHold = new ReportConfig(maker.getReportType(), "New " + maker.getReportType());
        maker.setReportConfig(toHold);
        List properties = maker.getReportProperties();
        toHold.synchronizeReportProperties(properties);
        List filters = maker.getReportFilterControls();
        toHold.synchronizeFilters(filters);
        this.newObjectReceived.emit((Object)toHold);
        this.filterEditor.setObject(toHold);
    }

    private void removeSearchButton() {
        for (Component c : this.filterEditor.getComponents()) {
            if (!(c instanceof JToolBar)) continue;
            this.filterEditor.remove(c);
            break;
        }
    }

    private List<String> getReportMakersAsynchronously() {
        final ArrayList<String> toReturn = new ArrayList<String>();
        Dialogs.showProgressDialog(new AbstractTask(){

            protected int getTotalSubTasks() {
                return 0;
            }

            public String getName() {
                return "Loading report configurations...";
            }

            protected void performTask() throws Exception {
                toReturn.addAll(OMReportMakerFactory.getInstance().getTypes());
            }
        });
        return toReturn;
    }
}

