/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.report.custom;

import au.com.ordermate.oquery.search.QueryPart;
import au.com.ordermate.util.StringUtils;
import ca.odell.glazedlists.BasicEventList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableListObjectEditor;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.screens.setup.configuration.report.custom.CustomReportQueryPartEditor;
import ordermate.database.reports.config.AbstractBaseReportCompiler;
import ordermate.database.reports.config.BaseReportCompiler;
import ordermate.database.reports.config.custom.CustomReport;
import ordermate.database.reports.config.custom.CustomReportQueryPart;
import ordermate.database.reports.config.custom.column.direct.BaseReport;
import ordermate.database.reports.config.custom.compiler.DefaultBaseReportCompilerFactory;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class CustomReportQueryPartTable
extends TableListObjectEditor<CustomReport, CustomReportQueryPart> {
    private JTextArea sqlArea;
    private JComboBox baseReportCombo;
    private JTextField subTypeField;

    public CustomReportQueryPartTable() {
        super(new PersistentObjectTable(new BasicEventList(), new ColumnTableFormat(new ColumnFormat[]{new PropertyColumnFormat(CustomReportQueryPart.Properties.BASE_REPORT), new PropertyColumnFormat(CustomReportQueryPart.Properties.PART_TYPE), new PropertyColumnFormat(CustomReportQueryPart.Properties.COL_NAME), new PropertyColumnFormat(CustomReportQueryPart.Properties.SEQUENCE)})), true);
        this.setElementEditor(new CustomReportQueryPartEditor());
        this.addQueryPanel();
    }

    private void addQueryPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setPreferredSize(new Dimension(400, 200));
        this.sqlArea = new JTextArea(10, 70);
        this.sqlArea.setEditable(false);
        this.sqlArea.setEnabled(true);
        panel.add((Component)new JScrollPane(this.sqlArea), "Center");
        JPanel holder = new JPanel();
        holder.setLayout(new BoxLayout(holder, 1));
        this.baseReportCombo = new JComboBox<BaseReport>(BaseReport.values());
        holder.add(this.baseReportCombo);
        this.subTypeField = new JTextField(20);
        holder.add(this.subTypeField);
        panel.add((Component)holder, "East");
        this.baseReportCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomReportQueryPartTable.this.updateSQL();
            }
        });
        this.add((Component)panel, "South");
    }

    private void updateSQL() {
        BaseReport baseReport = (BaseReport)this.baseReportCombo.getSelectedItem();
        if (baseReport != null) {
            BaseReportCompiler compiler;
            DefaultBaseReportCompilerFactory factory = new DefaultBaseReportCompilerFactory();
            String subType = this.subTypeField.getText();
            if (StringUtils.isEmpty((String)subType)) {
                subType = null;
            }
            if ((compiler = factory.createCompiler(baseReport, subType)) instanceof AbstractBaseReportCompiler) {
                ArrayList<CustomReportQueryPart> parts = new ArrayList<CustomReportQueryPart>();
                for (CustomReportQueryPart part : this.getObjectTable().getEventList()) {
                    parts.add(part);
                }
                compiler.applyQueryPart(parts);
                this.sqlArea.setText(((AbstractBaseReportCompiler)compiler).getSampleSQL());
            } else {
                this.sqlArea.setText("No SQL Available");
            }
        }
    }

    @Override
    public void gotParentDoubleClicked(Object obj) {
        this.editElement((CustomReportQueryPart)obj);
    }

    @Override
    public CustomReportQueryPart createNewObject() {
        QueryPart type = (QueryPart)Dialogs.showOptionDialog("Query Type", "Please choose a query part type", Arrays.asList(QueryPart.values()));
        if (type != null) {
            CustomReportQueryPart part = new CustomReportQueryPart((CustomReport)this.getObject(), type);
            int highest = 0;
            for (CustomReportQueryPart nextPart : ((CustomReport)this.getObject()).getQueryParts()) {
                if (highest >= nextPart.getSequence()) continue;
                highest = nextPart.getSequence();
            }
            part.setSequence(highest + 1);
            return part;
        }
        return null;
    }

    @Override
    public void addObjectToParent(CustomReportQueryPart toAdd) {
        ((CustomReport)this.getObject()).addQueryPart(toAdd);
    }

    @Override
    public void removeObjectFromParent(CustomReportQueryPart toRemove) {
        ((CustomReport)this.getObject()).removeQueryPart(toRemove);
    }

    @Override
    public Collection<CustomReportQueryPart> getParentList() {
        return ((CustomReport)this.getObject()).getQueryParts();
    }
}

