/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.report.custom;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.DefaultEventComboBoxModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComboBox;
import officemate.screens.setup.configuration.report.custom.CustomReportColumnEditor;
import ordermate.database.reports.config.BaseReportCompiler;
import ordermate.database.reports.config.custom.column.CustomReportColumn;
import ordermate.database.reports.config.custom.column.direct.BaseReport;
import ordermate.database.reports.config.custom.column.direct.DirectReportColumn;
import ordermate.database.reports.config.custom.compiler.DefaultBaseReportCompilerFactory;
import ordermate.gui.FieldPanelBuilder;

class DirectColumnEditor
extends CustomReportColumnEditor
implements ActionListener {
    private JComboBox reportCombo;
    private JComboBox reportPropCombo;
    private EventList<String> properties;

    DirectColumnEditor() {
    }

    @Override
    protected void addChildComponents(FieldPanelBuilder builder) {
        this.properties = new BasicEventList();
        EventList baseReports = GlazedLists.eventListOf((Object[])BaseReport.values());
        baseReports.remove((Object)BaseReport.Flexi);
        this.reportCombo = this.setupComboBox(DirectReportColumn.Properties.BASE_REPORT, baseReports);
        builder.addRow("Base Report", (Component)this.reportCombo);
        DefaultEventComboBoxModel model = new DefaultEventComboBoxModel(this.properties);
        this.reportPropCombo = new JComboBox(model);
        this.reportPropCombo.setEditable(true);
        builder.addRow("Base Report Property", (Component)this.reportPropCombo);
        builder.addRow("Sub Type", (Component)this.setupTextField(DirectReportColumn.Properties.SUB_TYPE, 15));
        builder.addRow("Cull if Null", (Component)this.setupCheckBox(DirectReportColumn.Properties.REMOVE_IF_NULL));
        builder.addRow("Omit Group", (Component)this.setupCheckBox(DirectReportColumn.Properties.OMIT_GROUP));
        this.reportCombo.addActionListener(this);
    }

    @Override
    public void setObject(CustomReportColumn column) {
        super.setObject(column);
        this.reportPropCombo.setSelectedItem(((DirectReportColumn)column).getBaseReportProperty());
    }

    @Override
    public void saveObject() {
        super.saveObject();
        Object prop = this.reportPropCombo.getSelectedItem();
        ((DirectReportColumn)this.getObject()).setBaseReportProperty(prop == null ? null : String.valueOf(prop));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object option = this.reportPropCombo.getSelectedItem();
        DefaultBaseReportCompilerFactory factory = new DefaultBaseReportCompilerFactory();
        BaseReportCompiler compiler = factory.createCompiler((BaseReport)this.reportCombo.getSelectedItem(), ((DirectReportColumn)this.getObject()).getSubType());
        List availableProps = compiler.getDirectColumns();
        Collections.sort(availableProps);
        this.properties.getReadWriteLock().writeLock().lock();
        this.properties.clear();
        this.properties.addAll((Collection)availableProps);
        this.properties.getReadWriteLock().writeLock().unlock();
        this.reportPropCombo.setSelectedItem(option);
    }
}

