/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.shift;

import au.com.ordermate.glazedlists.PropertyComparator;
import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.guicore.Refreshable;
import ca.odell.glazedlists.EventList;
import java.util.Collections;
import officemate.components.strategy.SaveStrategyFactory;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.EditablePropertyColumnFormat;
import ordermate.database.misc.ConfigShift;
import ordermate.database.users.AllPermissions;
import ordermate.reports.table.ColumnFormat;

public class ShiftState
extends AbstractEditableTableState<ConfigShift> {
    public ShiftState() {
        super("Shifts", AllPermissions.EDIT_SHIFTS, "Add, Edit and Remove shifts.");
        this.setSaveStrategy(SaveStrategyFactory.getDeferredSaveStrategy((Refreshable)this));
    }

    @Override
    protected ConfigShift createNewObject() {
        ConfigShift defaultShift = (ConfigShift)super.createNewObject();
        EventList shifts = this.getObjectList();
        if (!shifts.isEmpty()) {
            Collections.sort(shifts, new PropertyComparator(ConfigShift.Properties.SEQUENCE));
            int newSequence = ((ConfigShift)shifts.get(shifts.size() - 1)).getSequence() + 1;
            defaultShift.setSequence(Integer.valueOf(newSequence));
        } else {
            defaultShift.setSequence(Integer.valueOf(0));
        }
        return defaultShift;
    }

    @Override
    protected ObjectEditor<ConfigShift> createObjectEditor() {
        return null;
    }

    @Override
    public String getTypeName() {
        return "Shift";
    }

    @Override
    protected TableStateCentralArea<ConfigShift> createCentralArea() {
        ColumnTableFormat format = new ColumnTableFormat(new ColumnFormat[]{new EditablePropertyColumnFormat(ConfigShift.Properties.LABEL), new EditablePropertyColumnFormat(ConfigShift.Properties.SEQUENCE)});
        PersistentObjectTable<ConfigShift> tables = new PersistentObjectTable<ConfigShift>(this.getObjectList(), format);
        this.getSearchFactory().setSystemStateFilterActive(true);
        return tables;
    }

    @Override
    public void gotObjectDeleted(ConfigShift deletedObject) {
        super.gotObjectDeleted(deletedObject);
    }

    @Override
    protected Class<ConfigShift> getDisplayingType() {
        return ConfigShift.class;
    }
}

