/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.systemproperty;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.Price;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.Component;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import officemate.components.AbstractObjectEditor;
import officemate.components.BindingGuiSupportPanel;
import ordermate.database.integration.LoyaltyIntegrationConfig;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.enums.LoyaltyType;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.binding.BindingHelper;

public class PaymentSystemPropertyEditor
extends AbstractObjectEditor {
    private JComboBox loyaltyPointsCombo;
    private JSpinner redeemSpinner;
    private JSpinner accrueSpinner;

    public PaymentSystemPropertyEditor(BindingHelper parentBinding, BindingGuiSupportPanel.ObjectEditedListener parentListener) {
        super(parentBinding, parentListener);
    }

    @Override
    protected void init() {
        super.init();
        FieldPanelBuilder leftBuilder = new FieldPanelBuilder();
        JComponent toAdd = null;
        toAdd = this.setupCheckBox(SystemProperty.Properties.SHOW_PAYMENT_STATUS);
        leftBuilder.addRow("Show Payment Status", (Component)toAdd, "Enable/Disable payment status to be printed on prep dockets for phone, delivery & takeaway orders");
        toAdd = this.setupCheckBox(SystemProperty.Properties.BLIND_SKIM_ENABLED);
        leftBuilder.addRow("Blind Skim", (Component)toAdd, "Enable/Disable a completed skim to be required prior to viewing WaiterMate reports for the current shift");
        toAdd = this.setupCheckBox(SystemProperty.Properties.PRICE_BY_DEAREST);
        leftBuilder.addRow("Price by Dearest", (Component)toAdd, "Enable/Disable items ordered using portions to be charged at the price of the dearest portion");
        toAdd = this.setupCheckBox(SystemProperty.Properties.LOYALTY_ENABLED);
        leftBuilder.addRow("Loyalty Enabled", (Component)toAdd, "Enable/Disable the ability to configure loyalty points");
        toAdd = this.setupCheckBox(SystemProperty.Properties.PRICE_OVERRIDE_MODS);
        leftBuilder.addRow("Price Override Mods", (Component)toAdd, "Enable/Disable the ability to exclude the price of modifiers when added to an item in a combo");
        toAdd = this.setupCheckBox(SystemProperty.Properties.SINGLE_PAYMENT_MODE);
        leftBuilder.addRow("Single Payment Mode", (Component)toAdd, "Enable/Disable payments of only the total amount due to be paid to an account");
        toAdd = this.setupCheckBox(SystemProperty.Properties.RETRO_CUST_PRICE_UPDATES);
        leftBuilder.addRow("Retro customer price updates", (Component)toAdd, "Enable/Disable automatic price updates for items already ordered when a customer category trigger changes the price level");
        toAdd = this.setupCheckBox(SystemProperty.Properties.TAKINGS_EX_DISCOUNTS);
        leftBuilder.addRow("Takings Ex Discounts", (Component)toAdd, "Enable/Disable total Ex discount value to be included on the account sales report in WaiterMate");
        leftBuilder.addRow("Reconciliation System Total Includes Tips", (Component)this.setupCheckBox(SystemProperty.Properties.RECONCILIATION_SYSTEM_TOTAL_INCLUDES_TIPS), "Enable/Disable tips to be included in the system totals for payment types in reconciliation");
        leftBuilder.addRow("Enforce Base Price On Plus/Minus", (Component)this.setupCheckBox(SystemProperty.Properties.ENFORCE_BASE_PRICES_ENABLED), "Enable/Disable items prices to be set as a base price to prevent modifiers from lowering the price");
        leftBuilder.addRow("Show Change", (Component)this.setupCheckBox(SystemProperty.Properties.SHOW_CHANGE), "Enable/Disable the change to be visually displayed in WaiterMate once cash tendered is entered");
        FieldPanelBuilder rightBuilder = new FieldPanelBuilder();
        toAdd = this.setupPriceField((PropertiedObject.Property<Price>)SystemProperty.Properties.ACCOUNT_CREDIT_LIMIT, 10);
        rightBuilder.addRow("Account Credit Limit", (Component)toAdd, "Configure the default credit limit when creating debtor accounts");
        toAdd = this.setupPriceField((PropertiedObject.Property<Price>)SystemProperty.Properties.TAB_CREDIT_LIMIT, 10);
        rightBuilder.addRow("Tab Credit Limit", (Component)toAdd, "Configure the default credit limit when creating bar tabs");
        toAdd = this.setupPriceField((PropertiedObject.Property<Price>)SystemProperty.Properties.ROOM_CREDIT_LIMIT, 10);
        rightBuilder.addRow("Room Credit Limit", (Component)toAdd, "Configure the default credit limit when creating room charge accounts");
        EventList loyList = GlazedLists.eventList(LoyaltyType.register.values());
        this.loyaltyPointsCombo = this.setupComboBox(SystemProperty.Properties.LOYALTY_POINTS_TYPE, loyList);
        this.loyaltyPointsCombo.setName("Loyalty Points Type");
        rightBuilder.addRow("Loyalty Points Type", (Component)this.loyaltyPointsCombo, "Determine the strategy for calculating loyalty");
        this.redeemSpinner = this.setupNumberSpinner(SystemProperty.Properties.LOYALTY_REDEEM_RATIO, new Double(1.0), new Double(0.0), new Double(1000.0), new Double(1.0), null, 5);
        rightBuilder.addRow("Loyalty Redeem Ratio", (Component)this.redeemSpinner, "Configure the default loyalty redeem factor when using price level loyalty");
        this.accrueSpinner = this.setupNumberSpinner(SystemProperty.Properties.LOYALTY_ADD_RATIO, new Double(0.01), new Double(0.0), new Double(10.0), new Double(0.01), null, 5);
        rightBuilder.addRow("Loyalty Add Ratio", (Component)this.accrueSpinner, "Configure the default loyalty earn ratio factor when using price level loyalty");
        this.setLayout(new BoxLayout(this, 0));
        this.add(leftBuilder.getPanel());
        this.add(rightBuilder.getPanel());
    }

    private void setLoyaltyCompsEnabled() {
        LoyaltyIntegrationConfig loyaltyConfig = LoyaltyIntegrationConfig.getInstance();
        this.loyaltyPointsCombo.setEnabled(loyaltyConfig.getType().equals((Object)LoyaltyIntegrationConfig.LoyaltyIntegrationType.HO));
        this.redeemSpinner.setEnabled(loyaltyConfig.isCanModifyRatios());
        this.accrueSpinner.setEnabled(loyaltyConfig.isCanModifyRatios());
    }

    @Override
    public void refresh() {
        super.refresh();
        this.setLoyaltyCompsEnabled();
    }
}

