/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.systemproperty;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.util.Pair;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.AbstractObjectEditor;
import officemate.components.BindingGuiSupportPanel;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.enums.OversellModeType;
import ordermate.database.schedule.Schedule;
import ordermate.database.stock.StockControlProperty;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.binding.BindingHelper;

public class StockCountSystemPropertyEditor
extends AbstractObjectEditor<SystemProperty>
implements ActionListener {
    private JButton resetStockCount;
    private JComboBox resetScheduleRecurrenceCB;
    private Map<String, Pair<String, String>> stockOptions;
    private static final String NONE = "None";
    private static final String TRADING_DAY = "@tradingday";
    private static final String MIDNIGHT = "0 0 0 * * ?";
    private static final String CUSTOM = "Custom";
    public static final Pair<String, String> NONE_PAIR = new Pair((Object)"None", (Object)"None");
    public static final Pair<String, String> CHANGE_OF_DAY_PAIR = new Pair((Object)"Change Of Day", (Object)"@tradingday");
    public static final Pair<String, String> MIDNIGHT_PAIR = new Pair((Object)"Midnight", (Object)"0 0 0 * * ?");

    public StockCountSystemPropertyEditor(BindingHelper parentBinding, BindingGuiSupportPanel.ObjectEditedListener parentListener) {
        super(parentBinding, parentListener);
    }

    @Override
    protected void init() {
        super.init();
        this.stockOptions = new HashMap<String, Pair<String, String>>();
        this.stockOptions.put(NONE, NONE_PAIR);
        this.stockOptions.put(TRADING_DAY, CHANGE_OF_DAY_PAIR);
        this.stockOptions.put(MIDNIGHT, MIDNIGHT_PAIR);
        FieldPanelBuilder builder = new FieldPanelBuilder((JPanel)this);
        JComponent toAdd = null;
        toAdd = this.setupCheckBox(SystemProperty.Properties.STOCK_COUNTDOWN_ENABLED);
        builder.addRow("Enable Item Countdown", (Component)toAdd, " Enable / Disable the Item Countdown feature in WaiterMate");
        toAdd = this.setupCheckBox(SystemProperty.Properties.SHOW_STOCK_COUNT_IN_FRONT_END);
        builder.addRow("Show Item Countdown in WaiterMate", (Component)toAdd, "Enable / Disable the Item Countdown values to be shown on the item buttons in WaiterMate");
        EventList OMlist = GlazedLists.eventList(OversellModeType.register.values());
        toAdd = this.setupComboBox(SystemProperty.Properties.STOCK_COUNTDOWN_OVERSELL_MODE, OMlist);
        builder.addRow(" Item Countdown Oversell Strategy", (Component)toAdd, " Determine the Item Countdown Oversell Strategy");
        this.resetScheduleRecurrenceCB = new JComboBox<Pair>(new Pair[]{NONE_PAIR, CHANGE_OF_DAY_PAIR, MIDNIGHT_PAIR});
        this.resetScheduleRecurrenceCB.setRenderer(new ResetScheduleCBRenderer());
        this.resetScheduleRecurrenceCB.addActionListener(this);
        builder.addRow("Item Countdown Reset Schedule", (Component)this.resetScheduleRecurrenceCB, "Determine the strategy for resetting the current item Countdown values");
        this.resetStockCount = new JButton("Clear");
        this.resetStockCount.addActionListener(this);
        builder.addRow("Remove All Item Countdowns", (Component)this.resetStockCount, "Remove All Item Countdown values currently set");
        toAdd = this.setupCheckBox(SystemProperty.Properties.SHOW_SOH_IN_FRONT_END);
        builder.addRow("Show Stock on Hand in WaiterMate", (Component)toAdd, "Enable/Disable Stock on Hand Values to be displayed in WaiterMate");
        OMlist = GlazedLists.eventList(OversellModeType.register.values());
        toAdd = this.setupComboBox(SystemProperty.Properties.OVERSELL_MODE, OMlist);
        builder.addRow(" Stock on Hand Oversell Strategy", (Component)toAdd, "Determine the Stock on Hand Oversell Strategy");
        toAdd = this.setupCheckBox(SystemProperty.Properties.LOCK_STOCKLESS_ITEMS);
        builder.addRow("Zero Stock on Hand Oversell", (Component)toAdd, "Enable/Disable the ability to sell menu items where the Stock on Hand values are Zero.");
    }

    @Override
    public void refresh() {
        Pair<String, String> item;
        super.refresh();
        Schedule task = this.getStockResetTask();
        if (task != null && (item = this.stockOptions.get(task.getRecurrence())) == null) {
            Pair CustomPair = new Pair((Object)CUSTOM, (Object)task.getRecurrence());
            this.stockOptions.put(task.getRecurrence(), (Pair<String, String>)CustomPair);
            this.resetScheduleRecurrenceCB.addItem(CustomPair);
        }
        if (task == null || !SystemState.isActive((PersistentObject)task) || !task.isValidRecurrence()) {
            this.resetScheduleRecurrenceCB.setSelectedItem(this.stockOptions.get(NONE));
        } else {
            item = this.stockOptions.get(task.getRecurrence());
            if (item != null) {
                this.resetScheduleRecurrenceCB.setSelectedItem(item);
            }
        }
    }

    private Schedule getStockResetTask() {
        return (Schedule)PersistenceManager.getObject(Schedule.class, (String)Query.select(Schedule.class).equals(Schedule.Properties.TASK, (Object)"Reset Stock Countdowns").toString());
    }

    public void setStockCountDownEnabled(Boolean enabled) {
        StockControlProperty.getInstance().setStockCountDownEnabled(enabled.booleanValue());
        StockControlProperty.getInstance().save();
    }

    public void setShowsSOHInFrontEnd(Boolean enabled) {
        StockControlProperty.getInstance().setShowSOHInFrontEnd(enabled.booleanValue());
        StockControlProperty.getInstance().save();
    }

    public void setShowsStockCountInFrontEnd(Boolean enabled) {
        StockControlProperty.getInstance().setShowStockCountInFrontEnd(enabled.booleanValue());
        StockControlProperty.getInstance().save();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.resetStockCount) {
            if (Dialogs.showWarningDialog("Remove All Item Countdowns?", " This will remove all Item Countdowns currently in the system.")) {
                StockControlProperty.getInstance().clearStockCount();
            }
        } else if (e.getSource() == this.resetScheduleRecurrenceCB) {
            Pair selectedItem = (Pair)this.resetScheduleRecurrenceCB.getSelectedItem();
            Schedule task = this.getStockResetTask();
            if (selectedItem == null || ((String)selectedItem.key).equals(NONE)) {
                if (task != null) {
                    task.setSystemState(SystemState.DELETED_STATE);
                    task.save();
                }
            } else {
                if (task == null) {
                    task = new Schedule();
                    task.setLabel("Reset Stock Count");
                    task.setTask("Reset Stock Countdowns");
                }
                task.setSystemState(SystemState.ACTIVE_STATE);
                task.setRecurrence((String)selectedItem.value);
                task.save();
            }
        }
    }

    class ResetScheduleCBRenderer
    extends DefaultListCellRenderer {
        ResetScheduleCBRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String key = "";
            if (value instanceof Pair) {
                key = (String)((Pair)value).key;
            }
            return super.getListCellRendererComponent(list, key, index, isSelected, cellHasFocus);
        }
    }
}

