/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.systemproperty;

import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.persistence.Executable;
import au.com.ordermate.persistence.PersistenceManager;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.CompositeObjectEditor;
import officemate.screens.setup.configuration.systemproperty.GeneralSystemPropertyEditor;
import officemate.screens.setup.configuration.systemproperty.IntegrationSystemPropertyEditor;
import officemate.screens.setup.configuration.systemproperty.OrderingSystemPropertyEditor;
import officemate.screens.setup.configuration.systemproperty.PaymentSystemPropertyEditor;
import officemate.screens.setup.configuration.systemproperty.PrintingSystemPropertyEditor;
import officemate.screens.setup.configuration.systemproperty.StockCountSystemPropertyEditor;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.SystemPropertyRefreshExecutable;
import ordermate.gui.binding.BindingHelper;

public class SystemPropertyEditor
extends CompositeObjectEditor<SystemProperty> {
    public static final String GENERAL_TITLE = "General";
    public static final String INTEGRATION_TITLE = "Integration";
    public static final String PRINTING_TITLE = "Printing";
    public static final String ORDERING_TITLE = "Ordering";
    public static final String PAYMENT_TITLE = "Payment";
    public static final String ITEM_COUNTDOWN_TITLE = "Item Countdown";
    private SystemProperty systemProperty;

    public SystemPropertyEditor() {
        Dialogs.showProgressDialog(new LoadingTask());
    }

    @Override
    public void refresh() {
        super.refresh();
        PersistenceManager.getServerConnection().runSync((Executable)new SystemPropertyRefreshExecutable());
    }

    public void collapse() {
        this.systemProperty = null;
    }

    @Override
    public void setObject(final SystemProperty toEdit) {
        AbstractTask loadSystemProps = new AbstractTask(){

            public String getName() {
                return "Loading System Properties";
            }

            protected void performTask() throws Exception {
                if (SystemPropertyEditor.this.systemProperty == null) {
                    SystemPropertyEditor.super.setObject(toEdit);
                    SystemPropertyEditor.this.systemProperty = toEdit;
                }
            }

            protected int getTotalSubTasks() {
                return 1;
            }
        };
        Dialogs.createProgressDialog(loadSystemProps).start();
    }

    class LoadingTask
    extends AbstractTask {
        LoadingTask() {
        }

        public String getName() {
            return "Loading...";
        }

        protected void performTask() throws Exception {
            SystemPropertyEditor.this.addObjectEditorTab(SystemPropertyEditor.GENERAL_TITLE, new GeneralSystemPropertyEditor((BindingHelper<SystemProperty>)SystemPropertyEditor.this.getBindings(), SystemPropertyEditor.this.getListener()));
            this.emitProgress();
            SystemPropertyEditor.this.addObjectEditorTab(SystemPropertyEditor.INTEGRATION_TITLE, new IntegrationSystemPropertyEditor((BindingHelper<SystemProperty>)SystemPropertyEditor.this.getBindings(), SystemPropertyEditor.this.getListener()));
            this.emitProgress();
            SystemPropertyEditor.this.addObjectEditorTab(SystemPropertyEditor.PRINTING_TITLE, new PrintingSystemPropertyEditor(SystemPropertyEditor.this.getBindings(), SystemPropertyEditor.this.getListener()));
            this.emitProgress();
            SystemPropertyEditor.this.addObjectEditorTab(SystemPropertyEditor.ORDERING_TITLE, new OrderingSystemPropertyEditor(SystemPropertyEditor.this.getBindings(), SystemPropertyEditor.this.getListener()));
            this.emitProgress();
            SystemPropertyEditor.this.addObjectEditorTab(SystemPropertyEditor.PAYMENT_TITLE, new PaymentSystemPropertyEditor(SystemPropertyEditor.this.getBindings(), SystemPropertyEditor.this.getListener()));
            this.emitProgress();
            SystemPropertyEditor.this.addObjectEditorTab(SystemPropertyEditor.ITEM_COUNTDOWN_TITLE, new StockCountSystemPropertyEditor(SystemPropertyEditor.this.getBindings(), SystemPropertyEditor.this.getListener()));
        }

        protected int getTotalSubTasks() {
            return 6;
        }
    }
}

