/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.systemproperty.twitter;

import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.util.connectivity.TwitterHelper;
import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import officemate.OfficeMate;
import ordermate.database.misc.SystemProperty;
import ordermate.gui.FieldPanelBuilder;
import org.jdesktop.swingx.JXHeader;

public class TwitterCredentialsEditor
extends JDialog {
    private String username;
    private String password;
    private TwitterHelper helper = new TwitterHelper();
    private boolean configured = false;
    private String[] accessTokens;
    private boolean twitterActive;
    private JCheckBox activeCheckBox;

    public TwitterCredentialsEditor() {
        super(OfficeMate.getApplicationFrame(), "Twitter Credentials", true);
        this.makeUI();
        this.setLocationRelativeTo(OfficeMate.getApplicationFrame());
    }

    private void makeUI() {
        this.setLayout(new BorderLayout());
        this.setMinimumSize(new Dimension(300, 280));
        JPanel headerPane = new JPanel();
        headerPane.setLayout(new BoxLayout(headerPane, 3));
        JXHeader header = new JXHeader(this.getTitle(), "Please enter your username and password to connect to Twitter.\n", (Icon)IconLoader.get((String)"/ordermate/images/keys.png"));
        headerPane.add((Component)header);
        headerPane.add(new JSeparator());
        this.add((Component)headerPane, "First");
        FieldPanelBuilder builder = new FieldPanelBuilder();
        final JTextField usernameField = new JTextField(20);
        usernameField.setText(SystemProperty.getInstance().getTwitterUserName());
        builder.addRow("Twitter username", (Component)usernameField, "<html>The username of the twitter account used from waitermate.</html>");
        final JPasswordField passwordField = new JPasswordField(20);
        builder.addRow("Twitter password", (Component)passwordField, "Password of the twitter account to be used from waitermate.");
        this.activeCheckBox = new JCheckBox();
        this.activeCheckBox.setSelected(SystemProperty.getInstance().isTwitterActive());
        builder.addRow("Twitter active", (Component)this.activeCheckBox, "Sets whether twitter is active, unchecking this will disable twitter.");
        builder.addSeparator("");
        final JLabel errorText = new JLabel("<html><center>" + this.getMessage() + "</center></html>");
        builder.addRow("", (Component)errorText);
        builder.addSeparator("");
        this.add("Center", builder.getPanel());
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(new JButton((Action)new BasicAction("Ok"){

            public void actionPerformed(ActionEvent e) {
                TwitterCredentialsEditor.this.configured = true;
                TwitterCredentialsEditor.this.twitterActive = TwitterCredentialsEditor.this.activeCheckBox.isSelected();
                TwitterCredentialsEditor.this.username = usernameField.getText();
                TwitterCredentialsEditor.this.password = passwordField.getText();
                if (TwitterCredentialsEditor.this.twitterActive) {
                    String[] tokens = TwitterCredentialsEditor.this.helper.generateAccessTokens(usernameField.getText(), passwordField.getText());
                    if (tokens[0] == null || tokens[1] == null) {
                        errorText.setText("<html><center><strong>Can't connect to Twitter.</strong><br />Check your username and <br />password then try again.</center></html>");
                    } else {
                        errorText.setText("");
                        TwitterCredentialsEditor.access$602(TwitterCredentialsEditor.this, tokens);
                        TwitterCredentialsEditor.this.setVisible(false);
                    }
                } else {
                    TwitterCredentialsEditor.this.setVisible(false);
                    TwitterCredentialsEditor.access$602(TwitterCredentialsEditor.this, new String[2]);
                }
            }
        }));
        buttonPanel.add(new JButton((Action)new BasicAction("Cancel"){

            public void actionPerformed(ActionEvent e) {
                TwitterCredentialsEditor.this.configured = false;
                TwitterCredentialsEditor.this.setVisible(false);
            }
        }));
        this.activeCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                errorText.setText(TwitterCredentialsEditor.this.getMessage());
            }
        });
        this.add("South", buttonPanel);
        this.pack();
    }

    private String getMessage() {
        if (this.activeCheckBox != null && !this.activeCheckBox.isSelected()) {
            return "Twitter is currently not active.";
        }
        return "<html>Press OK to authenticate the <br/> above details with Twitter.</html>";
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isConfigured() {
        return this.configured;
    }

    public String[] getAccessTokens() {
        return this.accessTokens;
    }

    public boolean isTwitterActive() {
        return this.twitterActive;
    }

    static /* synthetic */ String[] access$602(TwitterCredentialsEditor x0, String[] x1) {
        x0.accessTokens = x1;
        return x1;
    }
}

