/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.waitermateproperty.configcolor;

import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.image.IconLoader;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import javax.swing.JButton;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.components.strategy.SaveStrategyFactory;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.EditablePropertyColumnFormat;
import officemate.components.tableformat.PropertyAccessorColumnFormat;
import officemate.components.tableformat.renderers.AbstractDialogCellEditor;
import officemate.screens.setup.configuration.waitermateproperty.configcolor.ConfigColorEditor;
import ordermate.database.misc.colour.ConfigColor;
import ordermate.database.misc.colour.ConfigColorSet;
import ordermate.database.users.AllPermissions;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class ConfigColourState
extends AbstractEditableTableState<ConfigColor> {
    private EventList<ConfigColor> coloursList = new BasicEventList();

    public ConfigColourState() {
        super("Configurable Colours", AllPermissions.CONFIG_COLOURS, "Change the way some colours appear.");
        this.setSmallIcon(IconLoader.get((String)"/officemate/images/colourpalettesmall.png"));
    }

    @Override
    protected void onStart() {
        this.refresh();
    }

    @Override
    protected void init() {
        if (this.initCalled) {
            return;
        }
        super.init();
        this.getCentralArea().objectDoubleClicked().disconnect((Object)this);
    }

    @Override
    protected ObjectEditor<ConfigColor> createObjectEditor() {
        return new ConfigColorEditor();
    }

    @Override
    public String getTypeName() {
        return "Configurable Colours";
    }

    @Override
    protected TableStateCentralArea<ConfigColor> createCentralArea() {
        this.setSaveStrategy(SaveStrategyFactory.getInstantSaveStrategy());
        EditablePropertyColumnFormat colourFormat = new EditablePropertyColumnFormat(ConfigColor.Properties.COLOR);
        JButton editButton = new JButton("...");
        colourFormat.setCustomEditor(new AbstractDialogCellEditor(editButton){

            @Override
            public Object doDialog() {
                ConfigColor toEdit = (ConfigColor)ConfigColourState.this.getCentralArea().getSelectedObject();
                if (toEdit != null) {
                    ConfigColourState.this.doEdit(toEdit);
                    return toEdit.getColor();
                }
                return null;
            }
        });
        ColumnTableFormat tableFormat = new ColumnTableFormat(new ColumnFormat[]{new PropertyColumnFormat(ConfigColor.Properties.KEY_NAME), new PropertyAccessorColumnFormat(ConfigColor.Properties.COLOR_SET, ConfigColorSet.Properties.NAME).setName("Colour Set"), colourFormat});
        PersistentObjectTable<ConfigColor> table = new PersistentObjectTable<ConfigColor>(this.coloursList, tableFormat);
        return table;
    }

    @Override
    protected Class<ConfigColor> getDisplayingType() {
        return ConfigColor.class;
    }

    @Override
    public EventList<ConfigColor> getObjectList() {
        return this.coloursList;
    }

    @Override
    public void refresh() {
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.coloursList, PersistenceManager.getObjectList(ConfigColor.class, (String)Query.select(ConfigColor.class).toString(), null));
    }

    @Override
    public boolean canCreateOrDelete() {
        return false;
    }
}

